import { request } from "../config";

// Lic在线验证列表
export const LOVLogList = (macAddress?: string, flag?: number, pageNo?: number, pageSize?: number) => {
    return request({
        url: '/api/lic/online/verification/log/list',
        method: 'get',
        params: { macAddress, flag, pageNo, pageSize }
    })
}

// Lic在线验证详情
export const LOVLogDetail = (id: number) => {
    return request({
        url: '/api/lic/online/verification/log/detail',
        method: 'get',
        params: { id }
    })
}

// Lic在线验证
export const LOV = (data: string) => {
    return request({
        url: '/api/lic/online/verification',
        method: 'delete',
        params: { data }
    })
}

// Lic在线验证删除
export const LOVLogDelete = (id: number) => {
    return request({
        url: '/api/lic/online/verification/log/delete',
        method: 'delete',
        params: { id }
    })
}