import { ActionContext } from "vuex";
import { RootState } from "..";
export type AppState = {
  clientHeight: any;
}
const state: AppState  = {
  clientHeight: 900
}

const mutations = {
  SET_CLIENTHEIGHT: (state: AppState, clientHeight: any) => {
    state.clientHeight = clientHeight
  }
}

const actions = {
  setClientHeight({ commit }: ActionContext<AppState, RootState>, clientHeight: any) {
    commit('SET_CLIENTHEIGHT', clientHeight)
  }
}

const getters = {
  getClientHeight() {
    return state.clientHeight
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions,
  getters
}
