import { request } from "../config";

// lic信息列表
export const licInfoList = (macAddress?: string, pageNo?: number, pageSize?: number) => {
    return request({
        url: '/api/lic/info/list',
        method: 'get',
        params: { macAddress, pageNo, pageSize }
    })
}

// 新增
export const licInfoCreate = (data: any) => {
    return request({
        url: '/api/lic/info/create',
        method: 'post',
        data
    })
}
// 更新
export const licInfoUpdate = (data: any) => {
    return request({
        url: '/api/lic/info/update',
        method: 'put',
        data
    })
}
// 删除
export const licInfoDelete = (id: number) => {
    return request({
        url: '/api/lic/info/delete',
        method: 'delete',
        params: { id }
    })
}
// 文件创建
export const licInfoFileCreate = (data: any) => {
    return request({
        url: '/api/lic/info/file/create',
        method: 'post',
        data
    })
}
