import { createRouter, createWebHashHistory, RouteRecordRaw } from "vue-router";
import Layout from "@/layout/index.vue";
import { start, close } from "@/utils/nprogress";

const routes: Array<RouteRecordRaw> = [
  {
    path: "/",
    component: Layout,
    redirect: "/licInformation",
    children: [],
  },
  {
    path: "/login",
    name: "login",
    component: () => import("@/views/login/login.vue"),
  },
  {
    path: "/404",
    name: "404",
    component: () => import("@/views/exception/404.vue"),
  },
];

export const asyncRoutes: Array<RouteRecordRaw> = [];

const router = createRouter({
  history: createWebHashHistory(),
  routes,
});

router.beforeEach(() => {
  start();
});

router.afterEach(() => {
  close();
});

export function addRoutes(routes: any) {
  router.addRoute(routes);
}

export default router;
