interface Scope {
  row: any;
  $index: number;
  cellIndex: number;
}

export interface FormItem {
  label: string;
  prop: string;
  type: "" | "input" | "radio" | "select" | "switch";
  selectProp?: {
    value: string;
    label: string;
  };
  hidden?: boolean;
  inputType?: string;
  viewType?: "field" | "avater" | "module"; // 表格渲染 field直接渲染 avatar渲染头像 module自定义渲染
  width?: string;
  fixed?: "left" | "right";
  sortable?: boolean;
}

interface TableConfigData {
  title: string;
  tableTitle: FormItem[];
  drawerformData: object;
  rules?: {
    [key: string]: {
      required: boolean;
      message: string;
      trigger: "blur";
    }[];
  };
  btnObj: {
    isAdd: boolean;
    isDelete: boolean;
    width?: string;
  };
  apiKey?: string;
  tableApi?: string;
  dataKey?: string;
}

export { Scope, TableConfigData };
