import { request } from "../config";

// 定时任务列表
export function getQuartzJobList() {
  return request({
    url: "/api/quartz/job/list",
    method: "get",
  });
}

// 定时任务创建
export function addQuartzJob(data?: any) {
  return request({
    url: "/api/quartz/job/create",
    method: "post",
    data,
  });
}

// 定时任务删除
export function deleteQuartzJob(parameters: { id: any }) {
  return request({
    url: "/api/quartz/job/delete",
    method: "delete",
    params: parameters,
  });
}

// 定时任务编辑
export function putQuartzJob(parameters: any) {
  return request({
    url: "/api/quartz/job/update",
    method: "put",
    data: parameters,
  });
}

// 定时任务暂停
export function deleteQuartzJobPause(parameters?: any) {
  return request({
    url: "/api/quartz/job/pause",
    method: "get",
    params: parameters,
  });
}

// 定时任务启动
export function deleteQuartzJobResume(parameters?: any) {
  return request({
    url: "/api/quartz/job/resume",
    method: "get",
    params: parameters,
  });
}
