import { TableConfigData } from "@/table/type";

const departmentData: TableConfigData = {
  title: '部门',
  tableTitle: [
    {
      label: '部门名称',
      prop: 'cname',
      type: 'input'
    },
    {
      label: '英文名称',
      prop: 'ename',
      type: 'input'
    },
    {
      label: '编号',
      prop: 'code',
      type: 'input'
    },
    {
      label: '类型',
      prop: 'type',
      type: 'input'
    }
  ],
  drawerformData: {
    id: '',
    type: 0,
    cname: '',
    ename: '',
    code: ''
  },
  rules: {
    cname: [
      { required: true, message: '请输入部门名称', trigger: 'blur' }
    ]
  },
  btnObj: {
    width: '200',
    isAdd: true,
    isDelete: true
  },
  apiKey: 'department',
  tableApi: '/index',
  dataKey: ''
}

export { departmentData }
