import { ref, onMounted } from "vue";
import { getQueryxyunLog } from "@/services/api/log/logApi";

export const useXyunLogTableList = () => {
  const tableList = ref([]);
  const total = ref(0)
  const loading = ref(true)
  onMounted(async () => {
    const res = await getQueryxyunLog();
    tableList.value = res.data.records;
    total.value = res.data.total
    loading.value = false
  });
  return {
    tableList,
    total,
    loading
  };
};
