import { getTableList } from '@/services/api/customTable'
import { ref } from 'vue'
import { useRoute } from 'vue-router'

export function tableLogic(props: Readonly<any>) {
  const tableData = ref([])
  
  const apiKey: any = useRoute().meta.apiKey
  const completeApi = props.tableConfigData.apiKey + props.tableConfigData.tableApi

  function init() {
    getTableList(completeApi ?? apiKey).then((res: any) => {
      if (res.code === 200) {
        console.log(res)
        if (props.tableConfigData.dataKey) {
          tableData.value = res.data[props.tableConfigData.dataKey]
        } else {
          tableData.value = res.data
        }
      }
    })
  }
  
  init()
  return {
    tableData,
    init
  }
}
