import { ref, onMounted } from "vue";
import { getQueryxyunLog } from "@/services/api/systemApi/log/logApi";

export const useXyunLogTableList = () => {
  const tableList = ref([]);
  const total = ref(0);
  // 当前页数
  const currentPage = ref(1);
  // 每页条数
  const pageSize = ref(10);
  const loading = ref(true);
  onMounted(async () => {
    const res = await getQueryxyunLog(currentPage.value, pageSize.value);
    console.log("数据", res);
    tableList.value = res.data.records;
    total.value = res.data.total;
    loading.value = false;
  });
  return {
    tableList,
    total,
    loading,
    currentPage,
    pageSize,
  };
};
