﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Model.ReportFilter;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.BOS.Core.List.PlugIn;
using System.Transactions;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn.Args;
using Kingdee.BOS.Core;

using Kingdee.BOS.Log;
using Kingdee.BOS.KDThread;

namespace LQKJ_OFLCostReport
{
    [Description("获取销售订单明细报表数据"), HotUpdate]
    public class CostReportPlugin : AbstractListPlugIn
    {
        private bool isLoading = false;

        public override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            if (isLoading) return;
            this.View.Session["ProcessRateValue"] = 0;
            ShowProgressBar(false);
        }

   

        private void ShowProgressBar(bool userTruePro)
        {
            this.View.ShowProcessForm(formResult => { }, userTruePro, "正在执行加载数据");
            // 启动线程执行耗时操作，同时更新执行进度
            MainWorker.QuequeTask(this.View.Context, () =>
            {
                try
                {
                    string sql = $@"IF EXISTS (SELECT * FROM sys.tables WHERE name = 'cbmxCursor')
BEGIN
    delete cbmxCursor where FUserID ={this.Context.UserId}
END";       
                    DBServiceHelper.Execute(this.Context, sql);
                    this.View.Session["ProcessRateValue"] = 10;
                    DataTable dataTable = GetSaleDetailData();
                    string tmpTableName = createTmpTable(dataTable);
                    //向表插入数据
                    using (KDTransactionScope scope = new KDTransactionScope(TransactionScopeOption.Required))
                    {
                        DBUtils.BulkInserts(this.Context, dataTable);
                        scope.Complete();
                    }
                    CreateView();
                    this.View.Session["ProcessRateValue"] = 100;
                    isLoading = true;
                    this.View.Refresh();

                }
                catch (Exception ex)
                {
                    this.View.ShowErrMessage(ex.Message);
                }
                finally
                {
                    this.View.SendDynamicFormAction(this.View);
                }
            }, null);
        }

        public override void FormClosed(FormClosedEventArgs e)
        {
            base.FormClosed(e);
            string sql = $@"IF EXISTS (SELECT * FROM sys.tables WHERE name = 'cbmxCursor')
BEGIN
    delete cbmxCursor where FUserID ={this.Context.UserId}
END";
            DBServiceHelper.Execute(this.Context, sql);
        }

        public override void PrepareFilterParameter(FilterArgs e)
        {
            base.PrepareFilterParameter(e);
            e.FilterString = $@"FUserID={this.Context.UserId}";
        }
        //  获取销售明细简单账表数据
        public DataTable GetSaleDetailData()
        {
            this.View.Session["ProcessRateValue"] = 20;
            ISysReportService sysReporSservice = ServiceFactory.GetSysReportService(this.Context);
            IPermissionService permissionService = ServiceFactory.GetPermissionService(this.Context);
            try
            {
                var filterMetadata = FormMetaDataCache.GetCachedFilterMetaData(this.Context);//加载字段比较条件元数据。
                var saleMetadata = FormMetaDataCache.GetCachedFormMetaData(this.Context, "HS_SALESLIST");//加载应收款账龄分析表元数据。
                var saleFilterMetadata = FormMetaDataCache.GetCachedFormMetaData(this.Context, "HS_SALESLISTFILTER");//加载应收款账龄分析表过滤条件元数据。
                var saleFilterServiceProvider = saleFilterMetadata.BusinessInfo.GetForm().GetFormServiceProvider();
                var model = new SysReportFilterModel();
                model.SetContext(this.Context, saleFilterMetadata.BusinessInfo, saleFilterServiceProvider);
                model.FormId = saleFilterMetadata.BusinessInfo.GetForm().Id;
                model.FilterObject.FilterMetaData = filterMetadata;
                model.InitFieldList(saleMetadata, saleFilterMetadata);
                model.GetSchemeList();
                string sql = $@"SELECT t1.FSCHEMEID FROM T_BAS_FILTERSCHEME t1 left join T_BAS_FILTERSCHEME_L t1L on t1.FSCHEMEID=t1L.FSCHEMEID where FDESCRIPTION='收入成本明细报表' and FFORMID='HS_SALESLIST' and FLOCALEID='2052'";
                DataTable dtFSCHEMEID= DBServiceHelper.ExecuteDataSet(this.Context, sql).Tables[0];
                if (dtFSCHEMEID.Rows.Count==0)
                {
                    throw new KDException("", "没有找到对应销售明细表过滤方案【收入成本明细报表】");
                }
                var entity = model.Load(Convert.ToString(dtFSCHEMEID.Rows[0]["FSCHEMEID"]));//过滤方案的主键值，可通过该SQL语句查询得到：SELECT * FROM T_BAS_FILTERSCHEME
                var filter = model.GetFilterParameter();
                IRptParams p = new RptParams();
                p.FormId = saleFilterMetadata.BusinessInfo.GetForm().Id;
                p.StartRow = 1;
                p.EndRow = int.MaxValue; //StartRow和EndRow是报表数据分页的起始行数和截至行数，一般取所有数据，所以EndRow取int最大值。
                p.FilterParameter = filter;
                p.FilterFieldInfo = model.FilterFieldInfo;
                p.BaseDataTempTable.AddRange(permissionService.GetBaseDataTempTable(this.Context, saleMetadata.BusinessInfo.GetForm().Id));
                using (DataTable dt = sysReporSservice.GetData(this.Context, saleMetadata.BusinessInfo, p))
                {
                    DataColumn newColumn = new DataColumn("FUserID", typeof(int));
                    dt.Columns.Add(newColumn);
                    foreach (DataRow row in dt.Rows)
                    {
                        row["FUserID"] = this.Context.UserId;  
                    }
                    //dt.Rows
                    return dt;
                    //dt就是报表数据，接下来就是你发挥的时间。
                }
            } finally
            {
                this.View.Session["ProcessRateValue"] = 50;
                ServiceFactory.CloseService(sysReporSservice);
                ServiceFactory.CloseService(permissionService);
            }

        }
        public string createTmpTable(DataTable data)
        {
            this.View.Session["ProcessRateValue"] = 60;
            string fieldColumnSql = GetCreateTmpTableNameSql(data.Columns);
            string tmpTableName = "cbmxCursor";
            data.TableName = tmpTableName;
            string createTmpTableSql = $@"/*dialect*/
IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = '{tmpTableName}')
BEGIN
    CREATE TABLE {tmpTableName} {fieldColumnSql};
    CREATE INDEX idx_cbmx_FBillEntryId ON {tmpTableName} (FBillEntryId);
    CREATE INDEX idx_cbmx_FBillNo ON {tmpTableName} (FBillNo);
    CREATE INDEX idx_cbmx_FBillSeq ON {tmpTableName} (FBillSeq);
    CREATE INDEX idx_cbmx_FSTOCKID ON {tmpTableName} (FSTOCKID);
    CREATE INDEX idx_cbmx_FEXPENSEID ON {tmpTableName} (FEXPENSEID);
    CREATE INDEX idx_cbmx_FUserId ON {tmpTableName} (FUserID);
END
ELSE
BEGIN
    ALTER INDEX idx_cbmx_FBillEntryId ON {tmpTableName} REBUILD;
    ALTER INDEX idx_cbmx_FBillNo ON {tmpTableName} REBUILD;
    ALTER INDEX idx_cbmx_FBillSeq ON {tmpTableName} REBUILD;
    ALTER INDEX idx_cbmx_FSTOCKID ON {tmpTableName} REBUILD;
    ALTER INDEX idx_cbmx_FEXPENSEID ON {tmpTableName} REBUILD;
    ALTER INDEX idx_cbmx_FUserId ON {tmpTableName} REBUILD;
END

";

            DBServiceHelper.Execute(this.Context, createTmpTableSql);
            this.View.Session["ProcessRateValue"] = 70;
            return tmpTableName;
        }

        private string GetCreateTmpTableNameSql(DataColumnCollection fieldColumn)
        {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.AppendLine("(");
            List<string> listStr = new List<string>();
            foreach (var field in fieldColumn)
            {
                listStr.Add(Convert.ToString(field).Trim() + " nvarchar(1000)");
            }
            stringBuilder.AppendLine(String.Join(",", listStr.Distinct()));
            stringBuilder.AppendLine(")");
            return stringBuilder.ToString();
        }
        private void CreateView()
        {
            this.View.Session["ProcessRateValue"] = 80;
            string sql = $@"/*dialect*/IF OBJECT_ID('T_BAS_PREBDTWO', 'V') IS NULL
    BEGIN
        EXEC('CREATE VIEW T_BAS_PREBDTWO AS
select ''0''                                             FNUMBER,
       ''0''                                             FMASTERID,
       ''0''                                             FUSEORGID,
       ''0''                                             FFORBIDSTATUS,
       ROW_NUMBER() OVER (ORDER BY t1.FBillEntryId) AS FID,
       t1.FBillDate                                    FOutBillDate,          -- 出库业务日期
       t1.FBillNo                                      FOutBillNo,            -- 出库单据编号
       t1.FBillSeq                                     FOutBillSeq,           -- 出库单据行号
       t1.FMATERIALID,                                                        -- 物料编码
       t1.FMaterialName,                                                      -- 物料名称
       t1.FSpecification,                                                     -- 规格型号
       ckmx.FREALQTY                                   FOutQty,               --出库数量
       t1.FUserID,
       ck.FNAME                                        FSTOCKID,              --仓库
       ISNULL(ckzjcl.FOutDirectMaterial, 0)            FOutDirectMaterial,    --出库直接材料
       ISNULL(ckzjrg.FOutDirectLabor, 0)               FOutDirectLabor,       --出库直接人工
       ISNULL(ckzzfy.FOutManufacturingCost, 0)         FOutManufacturingCost, --出库制造费用
       ISNULL(ckljzj.FOutAddDepreciation, 0)           FOutAddDepreciation,   --出库累计折旧
       ISNULL(ckzjcl.FOutDirectMaterial, 0) + ISNULL(ckzjrg.FOutDirectLabor, 0) + ISNULL(ckzzfy.FOutManufacturingCost, 0) +
               ISNULL(ckljzj.FOutAddDepreciation, 0)        FOutTotalCost,         --出库成本合计
       t3.FDATE                                        FRecBillDate,          --应收业务日期
       t3.FBILLNO                                      FRecBillNo,            --应收单据编号
       t2.FPRICEQTY                                    FPriceQty,             --计价数量
       t2.FTAXPRICE,                                                          --含税单价
       t2.FPRICE,                                                             --单价
       t2.FENTRYTAXRATE,                                                      --税率,
       t2.FNOTAXAMOUNTFOR,                                                    --不含税金额
       t2.FTAXAMOUNTFOR,                                                      --税额
       t2.FALLAMOUNTFOR,                                                      --价税合计
       -- 收入直接材料
       (ISNULL(ckzjcl.FOutDirectMaterial, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
        ISNULL(t2.FPRICEQTY, 0))                    AS FInDirectMaterial,

-- 收入直接人工
       (ISNULL(ckzjrg.FOutDirectLabor, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
        ISNULL(t2.FPRICEQTY, 0))                    AS FInDirectLabor,

-- 收入制造费用
       (ISNULL(ckzzfy.FOutManufacturingCost, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
        ISNULL(t2.FPRICEQTY, 0))                    AS FInManufacturingCost,

-- 收入累计折旧
       (ISNULL(ckljzj.FOutAddDepreciation, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
        ISNULL(t2.FPRICEQTY, 0))                    AS FInAddDepreciation,

-- 收入成本合计
       (ISNULL(ckzjcl.FOutDirectMaterial, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
       (ISNULL(ckzjrg.FOutDirectLabor, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
       (ISNULL(ckzzfy.FOutManufacturingCost, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
       (ISNULL(ckljzj.FOutAddDepreciation, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
        ISNULL(t2.FPRICEQTY, 0))                    AS FInTotalCost

from cbmxCursor t1
         left join T_SAL_OUTSTOCKENTRY ckmx on ckmx.FENTRYID = t1.FBillEntryId
         left join T_AR_RECEIVABLEENTRY_LK yslk 
                   on t1.FBillEntryId = yslk.FSID and yslk.FSTABLENAME = ''T_SAL_OUTSTOCKENTRY''
         left join t_AR_receivableEntry t2 
                   on t2.FENTRYID = yslk.FENTRYID
         left join T_AR_RECEIVABLE t3 on t2.FID = t3.FID
         left join T_BD_STOCK_L ck on t1.FSTOCKID = ck.FSTOCKID
         left join T_BD_EXPENSE t4 on t1.FEXPENSEID = t4.FNUMBER
         left join (SELECT t1.FBillNo, t1.FBillSeq, t1.FUserID,SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutDirectMaterial--直接材料
                    FROM cbmxCursor t1
                             left join T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                             left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                    where t2L.FNAME = ''材料成本'' and t1.FEXPENSENAME <> ''小计''
                    group by t1.FBillNo, t1.FBillSeq, t1.FUserID) ckzjcl
                   on t1.FBillNo = ckzjcl.FBillNo and t1.FBillSeq = ckzjcl.FBillSeq and t1.FUserID = ckzjcl.FUserID
         left join (SELECT t1.FBillNo, t1.FBillSeq, t1.FUserID, SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutDirectLabor--直接人工
                    FROM cbmxCursor t1
                             left join
                         T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                             left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                    where t2L.FNAME = ''工资'' and t1.FEXPENSENAME <> ''小计''
                    group by t1.FBillNo, t1.FBillSeq, t1.FUserID) ckzjrg
                   on t1.FBillNo = ckzjrg.FBillNo and t1.FBillSeq = ckzjrg.FBillSeq and t1.FUserID = ckzjrg.FUserID
         left join (SELECT t1.FBillNo, t1.FBillSeq, t1.FUserID, SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutManufacturingCost--制造费用
                    FROM cbmxCursor t1
                             left join
                         T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                             left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                    where t2L.FNAME <> ''材料成本''
                      and t2L.FNAME <> ''工资''
                      and FNAME not like ''%折旧%''
					  and t1.FEXPENSENAME <> ''小计''
                    group by t1.FBillNo, t1.FBillSeq, t1.FUserID) ckzzfy
                   on t1.FBillNo = ckzzfy.FBillNo and t1.FBillSeq = ckzzfy.FBillSeq and t1.FUserID = ckzzfy.FUserID
         left join (SELECT t1.FBillNo, t1.FBillSeq, t1.FUserID, SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutAddDepreciation --累计折旧
                    FROM cbmxCursor t1
                             left join
                         T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                             left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                    where FNAME like ''%折旧%'' and t1.FEXPENSENAME <> ''小计''
                    group by t1.FBillNo, t1.FBillSeq, t1.FUserID) ckljzj
                   on t1.FBillNo = ckljzj.FBillNo and t1.FBillSeq = ckljzj.FBillSeq and t1.FUserID = ckljzj.FUserID
-- where t1.FQTY<>''0.0000000000''
group by t1.FBillDate,
         t1.FBillNo,
         t1.FBillSeq,
         t1.FMATERIALID,
         t1.FMaterialName,
         t1.FSpecification,
         ckmx.FREALQTY,
         t1.FUserID,
         ck.FNAME,
         t3.FDATE,
         t3.FBILLNO,
         t2.FPRICEQTY,
         t2.FTAXPRICE,
         t2.FPRICE,
         t2.FENTRYTAXRATE,
         t2.FNOTAXAMOUNTFOR,
         t2.FTAXAMOUNTFOR,
         t2.FALLAMOUNTFOR,
         t1.FBillEntryId,
         ckzjcl.FOutDirectMaterial,
         ckzjrg.FOutDirectLabor,
         ckzzfy.FOutManufacturingCost,
         ckljzj.FOutAddDepreciation
')
    END
";
            DBServiceHelper.Execute(this.Context, sql);
            this.View.Session["ProcessRateValue"] = 90;
        } 
    }
}
