﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Model.ReportFilter;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.BOS.Core.List.PlugIn;
using System.Transactions;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn.Args;
using Kingdee.BOS.Core;

using Kingdee.BOS.Log;
using Kingdee.BOS.KDThread;

/*
 * 
 * 
一、IP地址：
IP：43.138.233.157
二、开机账号和密码
账号：Administrator
密码：Lykj201309@%
三、数据库：
账账号：sa
密码：lykj09@%sa
四、管理中心：
账号: lykj
密码: lykj2023@

业务中心
ZH012
用户名 ciou
密码   OFL@123456
 * */

namespace LQKJ_OFLCostReport
{
    [Description("获取销售订单明细报表数据"), HotUpdate]
    public class CostReportPlugin : AbstractListPlugIn
    {

        public override void PreOpenForm(PreOpenFormEventArgs e)
        {
            Clear(e.Context);
            base.PreOpenForm(e);
        }
        private void Clear(Context context)
        {
            if (DBServiceHelper.IsExistTable(context, "cbmxCursor"))
            {
                DBServiceHelper.Execute(context, $"DELETE FROM cbmxCursor_ckzjcl where FUserID ={context.UserId};");
                DBServiceHelper.Execute(context, $"DELETE FROM cbmxCursor_ckzjrg where FUserID ={context.UserId};");
                DBServiceHelper.Execute(context, $"DELETE FROM cbmxCursor_ckzzfy where FUserID ={context.UserId};");
                DBServiceHelper.Execute(context, $"DELETE FROM cbmxCursor_ckljzj where FUserID ={context.UserId};");
                DBServiceHelper.Execute(context, $"DELETE FROM cbmxCursor where FUserID ={context.UserId};");
            }
        }

        private bool isLoading = false;

        public override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            if (isLoading) return;
            this.View.Session["ProcessRateValue"] = 0;
            ShowProgressBar(false);
        }

        public override void FormClosed(FormClosedEventArgs e)
        {
            base.FormClosed(e);

            Clear(this.Context);

        }

        public override void PrepareFilterParameter(FilterArgs e)
        {
            base.PrepareFilterParameter(e);
            e.FilterString = $@"FUserID={this.Context.UserId}";
        }


        private void ShowProgressBar(bool userTruePro)
        {
            this.View.ShowProcessForm(formResult => { }, userTruePro, "正在执行加载数据");
            // 启动线程执行耗时操作，同时更新执行进度
            MainWorker.QuequeTask(this.View.Context, () =>
            {
                try
                {
                    this.View.Session["ProcessRateValue"] = 10;
                    string tmpTableName = GetSaleDetailData();
                    CreateView(tmpTableName);
                    this.View.Session["ProcessRateValue"] = 100;
                    isLoading = true;
                    this.View.Refresh();

                }
                catch (Exception ex)
                {
                    Logger.Error("销售订单明细报表", ex.Message, ex);
                    this.View.ShowErrMessage(ex.Message);
                }
                finally
                {
                    this.View.SendDynamicFormAction(this.View);
                }
            }, null);
        }

        //  获取销售明细简单账表数据
        public string GetSaleDetailData()
        {
            this.View.Session["ProcessRateValue"] = 20;
            ISysReportService sysReporSservice = ServiceFactory.GetSysReportService(this.Context);
            IPermissionService permissionService = ServiceFactory.GetPermissionService(this.Context);
            try
            {
                var filterMetadata = FormMetaDataCache.GetCachedFilterMetaData(this.Context);//加载字段比较条件元数据。
                var saleMetadata = FormMetaDataCache.GetCachedFormMetaData(this.Context, "HS_SALESLIST");//加载应收款账龄分析表元数据。
                var saleFilterMetadata = FormMetaDataCache.GetCachedFormMetaData(this.Context, "HS_SALESLISTFILTER");//加载应收款账龄分析表过滤条件元数据。
                var saleFilterServiceProvider = saleFilterMetadata.BusinessInfo.GetForm().GetFormServiceProvider();
                var model = new SysReportFilterModel();
                model.SetContext(this.Context, saleFilterMetadata.BusinessInfo, saleFilterServiceProvider);
                model.FormId = saleFilterMetadata.BusinessInfo.GetForm().Id;
                model.FilterObject.FilterMetaData = filterMetadata;
                model.InitFieldList(saleMetadata, saleFilterMetadata);
                model.GetSchemeList();
                string sql = $@"SELECT t1.FSCHEMEID FROM T_BAS_FILTERSCHEME t1 left join T_BAS_FILTERSCHEME_L t1L on t1.FSCHEMEID=t1L.FSCHEMEID where FDESCRIPTION='收入成本明细报表' and FFORMID='HS_SALESLIST' and FLOCALEID='2052'";
                DataTable dtFSCHEMEID= DBServiceHelper.ExecuteDataSet(this.Context, sql).Tables[0];
                if (dtFSCHEMEID.Rows.Count==0)
                {
                    throw new KDException("", "没有找到对应销售明细表过滤方案【收入成本明细报表】");
                }
                var entity = model.Load(Convert.ToString(dtFSCHEMEID.Rows[0]["FSCHEMEID"]));//过滤方案的主键值，可通过该SQL语句查询得到：SELECT * FROM T_BAS_FILTERSCHEME
                var filter = model.GetFilterParameter();
                IRptParams p = new RptParams();
                p.FormId = saleFilterMetadata.BusinessInfo.GetForm().Id;
                p.StartRow = 1;
                p.EndRow = int.MaxValue; //StartRow和EndRow是报表数据分页的起始行数和截至行数，一般取所有数据，所以EndRow取int最大值。
                p.FilterParameter = filter;
                p.FilterFieldInfo = model.FilterFieldInfo;
                p.BaseDataTempTable.AddRange(permissionService.GetBaseDataTempTable(this.Context, saleMetadata.BusinessInfo.GetForm().Id));
                return sysReporSservice.GetDataTableName(this.Context, saleMetadata.BusinessInfo, p);
            } finally
            {
                this.View.Session["ProcessRateValue"] = 50;
                ServiceFactory.CloseService(sysReporSservice);
                ServiceFactory.CloseService(permissionService);
            }
        }

        private void CreateView(string tmpTableName)
        {
            if (!DBServiceHelper.IsExistTable(this.Context, "cbmxCursor"))
            {
                DBServiceHelper.Execute(this.Context, $@"select *,{this.Context.UserId} FUSERID into cbmxCursor from {tmpTableName}");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                SELECT t1.FBillNo,
                        t1.FUSERID,
                        t1.FBillSeq,
                        SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutDirectMaterial--直接材料
                into cbmxCursor_ckzjcl FROM cbmxCursor t1
                            left join T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                            left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                where t2L.FNAME = '材料成本'
                    and t1.FEXPENSENAME <> '小计'
                group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                ");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                SELECT t1.FBillNo, t1.FUSERID, t1.FBillSeq, SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutDirectLabor--直接人工
                into cbmxCursor_ckzjrg FROM cbmxCursor t1
                            left join
                        T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                            left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                where t2L.FNAME = '工资'
                    and t1.FEXPENSENAME <> '小计'
                group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                ");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                SELECT t1.FBillNo,
                        t1.FUSERID,
                        t1.FBillSeq,
                        SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutManufacturingCost--制造费用
                into cbmxCursor_ckzzfy FROM cbmxCursor t1
                            left join
                        T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                            left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                where t2L.FNAME <> '材料成本'
                    and t2L.FNAME <> '工资'
                    and FNAME not like '%折旧费用%'
                    and t1.FEXPENSENAME <> '小计'
                group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                ");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                SELECT t1.FBillNo,
                        t1.FUSERID,
                        t1.FBillSeq,
                        SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutAddDepreciation --累计折旧
                into cbmxCursor_ckljzj FROM cbmxCursor t1
                            left join
                        T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                            left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                where FNAME like '%折旧费用%'
                    and t1.FEXPENSENAME <> '小计'
                group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                ");


                string createTmpTableSql = $@"/*dialect*/
                    CREATE INDEX idx_cbmx_FBillEntryId ON cbmxCursor (FBillEntryId);
                    CREATE INDEX idx_cbmx_FBillNo ON cbmxCursor (FBillNo);
                    CREATE INDEX idx_cbmx_FBillSeq ON cbmxCursor (FBillSeq);
                    CREATE INDEX idx_cbmx_FSTOCKID ON cbmxCursor (FSTOCKID);
                    CREATE INDEX idx_cbmx_FEXPENSEID ON cbmxCursor (FEXPENSEID);
                    CREATE INDEX idx_cbmx_FBillDate ON cbmxCursor (FBillDate);
                    CREATE INDEX idx_cbmx_FUserId ON cbmxCursor (FUserID);

                    CREATE INDEX idx_cbmxCursor_ckzjcl_FBillNo ON cbmxCursor_ckzjcl (FBillNo);
                    CREATE INDEX idx_cbmxCursor_ckzjcl_FBillSeq ON cbmxCursor_ckzjcl (FBillSeq);
                    CREATE INDEX idx_cbmxCursor_ckzjcl_FUserId ON cbmxCursor_ckzjcl (FUSERID);


                    CREATE INDEX idx_cbmxCursor_ckzjrg_FBillNo ON cbmxCursor_ckzjrg (FBillNo);
                    CREATE INDEX idx_cbmxCursor_ckzjrg_FBillSeq ON cbmxCursor_ckzjrg (FBillSeq);
                    CREATE INDEX idx_cbmxCursor_ckzjrg_FUserId ON cbmxCursor_ckzjrg (FUSERID);

                    CREATE INDEX idx_cbmxCursor_ckzzfy_FBillNo ON cbmxCursor_ckzzfy (FBillNo);
                    CREATE INDEX idx_cbmxCursor_ckzzfy_FBillSeq ON cbmxCursor_ckzzfy (FBillSeq);
                    CREATE INDEX idx_cbmxCursor_ckzzfy_FUserId ON cbmxCursor_ckzzfy (FUSERID);

                    CREATE INDEX idx_cbmxCursor_ckljzj_FBillNo ON cbmxCursor_ckljzj (FBillNo);
                    CREATE INDEX idx_cbmxCursor_ckljzj_FBillSeq ON cbmxCursor_ckljzj (FBillSeq);
                    CREATE INDEX idx_cbmxCursor_ckljzj_FUserId ON cbmxCursor_ckljzj (FUSERID);
                ";

                DBServiceHelper.Execute(this.Context, createTmpTableSql);

            }
            else
            {
                DBServiceHelper.Execute(this.Context, $@"insert into cbmxCursor select *,{this.Context.UserId} FUSERID from {tmpTableName}");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                        insert into cbmxCursor_ckzjcl SELECT t1.FBillNo,
                                t1.FUSERID,
                                t1.FBillSeq,
                                SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutDirectMaterial--直接材料
                        FROM cbmxCursor t1
                                    left join T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                                    left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                        where t2L.FNAME = '材料成本'
                            and t1.FEXPENSENAME <> '小计'
                            and t1.FUSERID = {this.Context.UserId}
                        group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                        ");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                        insert into cbmxCursor_ckzjrg SELECT t1.FBillNo,t1.FUSERID, t1.FBillSeq, SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutDirectLabor--直接人工
                        FROM cbmxCursor t1
                                    left join
                                T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                                    left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                        where t2L.FNAME = '工资'
                            and t1.FEXPENSENAME <> '小计'
                            and t1.FUSERID = {this.Context.UserId}
                        group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                        ");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                        insert into cbmxCursor_ckzzfy SELECT t1.FBillNo,
                                t1.FUSERID,
                                t1.FBillSeq,
                                SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutManufacturingCost--制造费用
                        FROM cbmxCursor t1
                                    left join
                                T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                                    left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                        where t2L.FNAME <> '材料成本'
                            and t2L.FNAME <> '工资'
                            and FNAME not like '%折旧费用%'
                            and t1.FEXPENSENAME <> '小计'
                            and t1.FUSERID = {this.Context.UserId}
                        group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                        ");

                DBServiceHelper.Execute(this.Context, $@"/*dialect*/
                        insert into cbmxCursor_ckljzj SELECT t1.FBillNo,
                                t1.FUSERID,
                                t1.FBillSeq,
                                SUM(CAST(t1.FAmount AS DECIMAL(18, 2))) FOutAddDepreciation --累计折旧
                        FROM cbmxCursor t1
                                    left join
                                T_BD_EXPENSE t2 ON t1.FEXPENSEID = t2.FNUMBER
                                    left join T_BD_EXPENSE_L t2L on t2.FEXPID = t2L.FEXPID and t2L.FLOCALEID = 2052
                        where FNAME like '%折旧费用%'
                            and t1.FEXPENSENAME <> '小计'
                            and t1.FUSERID = {this.Context.UserId}
                        group by t1.FBillNo, t1.FBillSeq, t1.FUSERID
                        ");


                string createTmpTableSql = $@"/*dialect*/
                    ALTER INDEX idx_cbmx_FBillEntryId ON cbmxCursor REBUILD;
                    ALTER INDEX idx_cbmx_FBillNo ON cbmxCursor REBUILD;
                    ALTER INDEX idx_cbmx_FBillSeq ON cbmxCursor REBUILD;
                    ALTER INDEX idx_cbmx_FSTOCKID ON cbmxCursor REBUILD;
                    ALTER INDEX idx_cbmx_FEXPENSEID ON cbmxCursor REBUILD;
                    ALTER INDEX idx_cbmx_FBillDate ON cbmxCursor REBUILD;
                    ALTER INDEX idx_cbmx_FUserId ON cbmxCursor REBUILD;


                    ALTER INDEX idx_cbmxCursor_ckzjcl_FBillNo ON cbmxCursor_ckzjcl REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckzjcl_FBillSeq ON cbmxCursor_ckzjcl REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckzjcl_FUserId ON cbmxCursor_ckzjcl REBUILD;


                    ALTER INDEX idx_cbmxCursor_ckzjrg_FBillNo ON cbmxCursor_ckzjrg REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckzjrg_FBillSeq ON cbmxCursor_ckzjrg REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckzjrg_FUserId ON cbmxCursor_ckzjrg REBUILD;

                    ALTER INDEX idx_cbmxCursor_ckzzfy_FBillNo ON cbmxCursor_ckzzfy REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckzzfy_FBillSeq ON cbmxCursor_ckzzfy REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckzzfy_FUserId ON cbmxCursor_ckzzfy REBUILD;

                    ALTER INDEX idx_cbmxCursor_ckljzj_FBillNo ON cbmxCursor_ckljzj REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckljzj_FBillSeq ON cbmxCursor_ckljzj REBUILD;
                    ALTER INDEX idx_cbmxCursor_ckljzj_FUserId ON cbmxCursor_ckljzj REBUILD;
                ";

                DBServiceHelper.Execute(this.Context, createTmpTableSql);

            }


            this.View.Session["ProcessRateValue"] = 80;
            string sql = $@"/*dialect*/IF OBJECT_ID('T_BAS_PREBDTWO', 'V') IS NULL
                    BEGIN
                        EXEC('CREATE VIEW T_BAS_PREBDTWO AS
                select  ROW_NUMBER() OVER (ORDER BY FOutBillNo,FOutBillSeq) AS FID,* from (
                select ''0''                                             FNUMBER,
                       ''0''                                             FMASTERID,
                       ''0''                                             FUSEORGID,
                       ''0''                                             FFORBIDSTATUS,
                       t1.FBillDate                                    FOutBillDate,          -- 出库业务日期
                       t1.FBillNo                                      FOutBillNo,            -- 出库单据编号
                       t1.FBillSeq                                     FOutBillSeq,           -- 出库单据行号
                       t5.FNUMBER                                      FMATERIALID,           -- 物料编码
                       t1.FMaterialName,                                                      -- 物料名称
                       t1.FSpecification,                                                     -- 规格型号
                       ckmx.FREALQTY                                   FOutQty,               --出库数量
                       ck.FNAME                                        FSTOCKID,              --仓库
                       t1.FUSERID,
                       ISNULL(ckzjcl.FOutDirectMaterial, 0)            FOutDirectMaterial,    --出库直接材料
                       ISNULL(ckzjrg.FOutDirectLabor, 0)               FOutDirectLabor,       --出库直接人工
                       ISNULL(ckzzfy.FOutManufacturingCost, 0)         FOutManufacturingCost, --出库制造费用
                       ISNULL(ckljzj.FOutAddDepreciation, 0)           FOutAddDepreciation,   --出库累计折旧
                       ISNULL(ckzjcl.FOutDirectMaterial, 0) + ISNULL(ckzjrg.FOutDirectLabor, 0) +
                       ISNULL(ckzzfy.FOutManufacturingCost, 0) +
                       ISNULL(ckljzj.FOutAddDepreciation, 0)           FOutTotalCost,         --出库成本合计
                       t3.FDATE                                        FRecBillDate,          --应收业务日期
                       t3.FBILLNO                                      FRecBillNo,            --应收单据编号
                       t2.FPRICEQTY                                    FPriceQty,             --计价数量
                       t2.FTAXPRICE,                                                          --含税单价
                       t2.FPRICE,                                                             --单价
                       t2.FENTRYTAXRATE,                                                      --税率,
                       t2.FNOTAXAMOUNT                                 FNOTAXAMOUNTFOR,       --不含税金额
                       t2.FTAXAMOUNTFOR,                                                      --税额
                       t2.FALLAMOUNTFOR,                                                      --价税合计
                       (ISNULL(ckzjcl.FOutDirectMaterial, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                        ISNULL(t2.FPRICEQTY, 0))                    AS FInDirectMaterial,     -- 收入直接材料
                       (ISNULL(ckzjrg.FOutDirectLabor, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                        ISNULL(t2.FPRICEQTY, 0))                    AS FInDirectLabor,        -- 收入直接人工
                       (ISNULL(ckzzfy.FOutManufacturingCost, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                        ISNULL(t2.FPRICEQTY, 0))                    AS FInManufacturingCost,  -- 收入制造费用
                       (ISNULL(ckljzj.FOutAddDepreciation, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                        ISNULL(t2.FPRICEQTY, 0))                    AS FInAddDepreciation,    -- 收入累计折旧
                       (ISNULL(ckzjcl.FOutDirectMaterial, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
                       (ISNULL(ckzjrg.FOutDirectLabor, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
                       (ISNULL(ckzzfy.FOutManufacturingCost, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
                       (ISNULL(ckljzj.FOutAddDepreciation, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                        ISNULL(t2.FPRICEQTY, 0))                    AS FInTotalCost           -- 收入成本合计
                from cbmxCursor t1
                         left join T_SAL_OUTSTOCKENTRY ckmx on ckmx.FENTRYID = t1.FBillEntryId and t1.FBillFormId = ''SAL_OUTSTOCK''
                         left join T_AR_RECEIVABLEENTRY_LK yslk
                                   on t1.FBillEntryId = yslk.FSID and yslk.FSTABLENAME = ''T_SAL_OUTSTOCKENTRY''
                         left join t_AR_receivableEntry t2
                                   on t2.FENTRYID = yslk.FENTRYID
                         left join T_AR_RECEIVABLE t3 on t2.FID = t3.FID
                         left join T_BD_STOCK_L ck on t1.FSTOCKID = ck.FSTOCKID
                         left join T_BD_EXPENSE t4 on t1.FEXPENSEID = t4.FNUMBER
                         left join T_BD_MATERIAL t5 on t1.FMATERIALID = t5.FMATERIALID
                         left join cbmxCursor_ckzjcl ckzjcl
                                   on t1.FBillNo = ckzjcl.FBillNo and t1.FBillSeq = ckzjcl.FBillSeq and t1.FUSERID = ckzjcl.FUSERID
                         left join cbmxCursor_ckzjrg ckzjrg
                                   on t1.FBillNo = ckzjrg.FBillNo and t1.FBillSeq = ckzjrg.FBillSeq and t1.FUSERID = ckzjrg.FUSERID
                         left join cbmxCursor_ckzzfy ckzzfy
                                   on t1.FBillNo = ckzzfy.FBillNo and t1.FBillSeq = ckzzfy.FBillSeq and t1.FUSERID = ckzzfy.FUSERID
                         left join cbmxCursor_ckljzj ckljzj
                                   on t1.FBillNo = ckljzj.FBillNo and t1.FBillSeq = ckljzj.FBillSeq and t1.FUSERID = ckljzj.FUSERID
                where ckmx.FID is not null
                group by t1.FBillDate,
                         t1.FBillNo,
                         t1.FBillSeq,
                         t5.FNUMBER,
                         t1.FMaterialName,
                         t1.FSpecification,
                         ckmx.FREALQTY,
                         ck.FNAME,
                         t3.FDATE,
                         t1.FUSERID,
                         t3.FBILLNO,
                         t2.FPRICEQTY,
                         t2.FTAXPRICE,
                         t2.FPRICE,
                         t2.FENTRYTAXRATE,
                         t2.FNOTAXAMOUNT,
                         t2.FTAXAMOUNTFOR,
                         t2.FALLAMOUNTFOR,
                         t1.FBillEntryId,
                         ckzjcl.FOutDirectMaterial,
                         ckzjrg.FOutDirectLabor,
                         ckzzfy.FOutManufacturingCost,
                         ckljzj.FOutAddDepreciation
                union all
                select DISTINCT ''0''                                             FNUMBER,
                                ''0''                                             FMASTERID,
                                ''0''                                             FUSEORGID,
                                ''0''                                             FFORBIDSTATUS,
                                t1.FBillDate                                    FOutBillDate,          -- 出库业务日期
                                t1.FBillNo                                      FOutBillNo,            -- 出库单据编号
                                t1.FBillSeq                                     FOutBillSeq,           -- 出库单据行号
                                t5.FNUMBER                                      FMATERIALID,           -- 物料编码
                                t1.FMaterialName,                                                      -- 物料名称
                                t1.FSpecification,                                                     -- 规格型号
                                -ckmx.FREALQTY                                   FOutQty,               --出库数量
                                ck.FNAME                                        FSTOCKID,              --仓库
                                t1.FUSERID,
                                ISNULL(ckzjcl.FOutDirectMaterial, 0)            FOutDirectMaterial,    --出库直接材料
                                ISNULL(ckzjrg.FOutDirectLabor, 0)               FOutDirectLabor,       --出库直接人工
                                ISNULL(ckzzfy.FOutManufacturingCost, 0)         FOutManufacturingCost, --出库制造费用
                                ISNULL(ckljzj.FOutAddDepreciation, 0)           FOutAddDepreciation,   --出库累计折旧
                                (ISNULL(ckzjcl.FOutDirectMaterial, 0) + ISNULL(ckzjrg.FOutDirectLabor, 0) +
                                ISNULL(ckzzfy.FOutManufacturingCost, 0) +
                                ISNULL(ckljzj.FOutAddDepreciation, 0))           FOutTotalCost,         --出库成本合计
                                t3.FDATE                                        FRecBillDate,          --应收业务日期
                                t3.FBILLNO                                      FRecBillNo,            --应收单据编号
                                t2.FPRICEQTY                                    FPriceQty,             --计价数量
                                t2.FTAXPRICE,                                                          --含税单价
                                t2.FPRICE,                                                             --单价
                                t2.FENTRYTAXRATE,                                                      --税率,
                                t2.FNOTAXAMOUNT                                 FNOTAXAMOUNTFOR,       --不含税金额
                                t2.FTAXAMOUNTFOR,                                                      --税额
                                t2.FALLAMOUNTFOR,                                                      --价税合计
                                -- 收入直接材料
                                -(ISNULL(ckzjcl.FOutDirectMaterial, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                                 ISNULL(t2.FPRICEQTY, 0))                    AS FInDirectMaterial,
								-- 收入直接人工
                                -(ISNULL(ckzjrg.FOutDirectLabor, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                                 ISNULL(t2.FPRICEQTY, 0))                    AS FInDirectLabor,
								-- 收入制造费用
                                -(ISNULL(ckzzfy.FOutManufacturingCost, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                                 ISNULL(t2.FPRICEQTY, 0))                    AS FInManufacturingCost,
								-- 收入累计折旧
                                -(ISNULL(ckljzj.FOutAddDepreciation, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                                 ISNULL(t2.FPRICEQTY, 0))                    AS FInAddDepreciation,
								-- 收入成本合计
                                -((ISNULL(ckzjcl.FOutDirectMaterial, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
                                (ISNULL(ckzjrg.FOutDirectLabor, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) * ISNULL(t2.FPRICEQTY, 0)) +
                                (ISNULL(ckzzfy.FOutManufacturingCost, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                                 ISNULL(t2.FPRICEQTY, 0)) +
                                (ISNULL(ckljzj.FOutAddDepreciation, 0) / NULLIF(ISNULL(ckmx.FREALQTY, 0), 0) *
                                 ISNULL(t2.FPRICEQTY, 0)))                    AS FInTotalCost
                from cbmxCursor t1
                         left join T_SAL_RETURNSTOCKENTRY ckmx on ckmx.FENTRYID = t1.FBillEntryId and t1.FBillFormId = ''SAL_RETURNSTOCK''
                         left join T_AR_RECEIVABLEENTRY_LK yslk
                                   on t1.FBillEntryId = yslk.FSID and yslk.FSTABLENAME = ''T_SAL_RETURNSTOCKENTRY''
                         left join t_AR_receivableEntry t2
                                   on t2.FENTRYID = yslk.FENTRYID
                         left join T_AR_RECEIVABLE t3 on t2.FID = t3.FID
                         left join T_BD_STOCK_L ck on t1.FSTOCKID = ck.FSTOCKID
                         left join T_BD_EXPENSE t4 on t1.FEXPENSEID = t4.FNUMBER
                         left join T_BD_MATERIAL t5 on t1.FMATERIALID = t5.FMATERIALID
                         left join cbmxCursor_ckzjcl ckzjcl
                                   on t1.FBillNo = ckzjcl.FBillNo and t1.FBillSeq = ckzjcl.FBillSeq and t1.FUSERID = ckzjcl.FUSERID
                         left join cbmxCursor_ckzjrg ckzjrg
                                   on t1.FBillNo = ckzjrg.FBillNo and t1.FBillSeq = ckzjrg.FBillSeq and t1.FUSERID = ckzjrg.FUSERID
                         left join cbmxCursor_ckzzfy ckzzfy
                                   on t1.FBillNo = ckzzfy.FBillNo and t1.FBillSeq = ckzzfy.FBillSeq and t1.FUSERID = ckzzfy.FUSERID
                         left join cbmxCursor_ckljzj ckljzj
                                   on t1.FBillNo = ckljzj.FBillNo and t1.FBillSeq = ckljzj.FBillSeq and t1.FUSERID = ckljzj.FUSERID
                where ckmx.FID is not null
                union all
                --查没有原单应收单
                select ''0''                                         FNUMBER,
                       ''0''                                         FMASTERID,
                       ''0''                                         FUSEORGID,
                       ''0''                                         FFORBIDSTATUS,
                       null                                        FOutBillDate,          -- 出库业务日期
                       null                                        FOutBillNo,            -- 出库单据编号
                       null                                        FOutBillSeq,           -- 出库单据行号
                       t3.FNUMBER                                  FMATERIALID,           -- 物料编码
                       t3L.FNAME,                                                         -- 物料名称
                       t3L.FSpecification,                                                -- 规格型号
                       0                                           FOutQty,               --出库数量
                       null                                        FSTOCKID,              --仓库
                       t4.FUSERID,
                       0                                           FOutDirectMaterial,    --出库直接材料
                       0                                           FOutDirectLabor,       --出库直接人工
                       0                                           FOutManufacturingCost, --出库制造费用
                       0                                           FOutAddDepreciation,   --出库累计折旧
                       0                                           FOutTotalCost,         --出库成本合计
                       t1.FDATE                                    FRecBillDate,          --应收业务日期
                       t1.FBILLNO                                  FRecBillNo,            --应收单据编号
                       t2.FPRICEQTY                                FPriceQty,             --计价数量
                       t2.FTAXPRICE,                                                      --含税单价
                       t2.FPRICE,                                                         --单价
                       t2.FENTRYTAXRATE,                                                  --税率,
                       t2.FNOTAXAMOUNT                             FNOTAXAMOUNTFOR,       --不含税金额
                       t2.FTAXAMOUNTFOR,                                                  --税额
                       t2.FALLAMOUNTFOR,                                                  --价税合计
                       0                                        AS FInDirectMaterial,     -- 收入直接材料
                       0                                        AS FInDirectLabor,        -- 收入直接人工
                       0                                        AS FInManufacturingCost,  -- 收入制造费用
                       0                                        AS FInAddDepreciation,    -- 收入累计折旧
                       0                                        AS FInTotalCost           -- 收入成本合计
                from (select FUserID from cbmxCursor group by FUserID) t4
					cross join t_AR_receivable t1
                         left join T_AR_RECEIVABLEENTRY t2 on t1.FID = t2.FID
                         left join T_BD_MATERIAL t3 on t3.FMATERIALID = t2.FMATERIALID
                         left join T_BD_MATERIAL_L t3L on t3.FMATERIALID = t3L.FMATERIALID and t3L.FLOCALEID = 2052
                where FSOURCETYPE = ''''
                union all
                select ''0''                                             FNUMBER,
                       ''0''                                             FMASTERID,
                       ''0''                                             FUSEORGID,
                       ''0''                                             FFORBIDSTATUS,
                       t1.FDATE                                        FOutBillDate,          -- 出库业务日期
                       t1.FBillNo                                      FOutBillNo,            -- 出库单据编号
                       ckmx.FSEQ                                     FOutBillSeq,           -- 出库单据行号
                       t5.FNUMBER                                      FMATERIALID,           -- 物料编码
                       t5_L.FNAME FMaterialName,                                                      -- 物料名称
                       t5_L.FSPECIFICATION FSpecification,                                                     -- 规格型号
                       ckmx.FREALQTY                                   FOutQty,               --出库数量
                       ck.FNAME                                        FSTOCKID,              --仓库
                       t4.FUSERID,
                       0            FOutDirectMaterial,    --出库直接材料
                       0              FOutDirectLabor,       --出库直接人工
                       0        FOutManufacturingCost, --出库制造费用
                       0          FOutAddDepreciation,   --出库累计折旧
                       ckmxf.FCOSTAMOUNT           FOutTotalCost,         --出库成本合计
                       t3.FDATE                                        FRecBillDate,          --应收业务日期
                       t3.FBILLNO                                      FRecBillNo,            --应收单据编号
                       t2.FPRICEQTY                                    FPriceQty,             --计价数量
                       t2.FTAXPRICE,                                                          --含税单价
                       t2.FPRICE,                                                             --单价
                       t2.FENTRYTAXRATE,                                                      --税率,
                       t2.FNOTAXAMOUNT                                 FNOTAXAMOUNTFOR,       --不含税金额
                       t2.FTAXAMOUNTFOR,                                                      --税额
                       t2.FALLAMOUNTFOR,                                                      --价税合计
                       0                    AS FInDirectMaterial,     -- 收入直接材料
                       0                   AS FInDirectLabor,        -- 收入直接人工
                       0                   AS FInManufacturingCost,  -- 收入制造费用
                       0                   AS FInAddDepreciation,    -- 收入累计折旧
                       t2.FCOSTAMTSUM                   AS FInTotalCost           -- 收入成本合计
                from T_SAL_INITOUTSTOCK t1
                         left join T_SAL_INITOUTSTOCKENTRY ckmx on ckmx.FID = t1.FID
                         left join T_SAL_INITOUTSTOCKENTRY_F ckmxf on ckmxf.FENTRYID = ckmx.FENTRYID
                         left join T_AR_RECEIVABLEENTRY_LK yslk
                                   on ckmx.FENTRYID = yslk.FSID and yslk.FSTABLENAME = ''T_SAL_INITOUTSTOCKENTRY''
                         left join t_AR_receivableEntry t2
                                   on t2.FENTRYID = yslk.FENTRYID
                         left join T_AR_RECEIVABLE t3 on t2.FID = t3.FID
                         left join T_BD_STOCK_L ck on ckmx.FSTOCKID = ck.FSTOCKID
                         left join T_BD_MATERIAL t5 on ckmx.FMATERIALID = t5.FMATERIALID
						 left join T_BD_MATERIAL_L t5_L on t5.FMATERIALID = t5_L.FMATERIALID and t5_L.FLOCALEID = 2052
						 cross join (select FUserID from cbmxCursor group by FUserID) t4 
                where ckmx.FID is not null
                )t1
                ')
                    END
                ";
            Logger.Info("CreateView.SQL", sql);
            DBServiceHelper.Execute(this.Context, sql);
            this.View.Session["ProcessRateValue"] = 90;
        } 
    }
}
