import type { App } from 'vue'
import 'element-plus/dist/index.css'

import PrintTemplate from './printTemplate/components/printDrawer.vue'

const components = [
    PrintTemplate
]

components.forEach(
    component =>
    (component.install = (app: App) => {
        app.component(component.name, component)
    })
)

const install = (app: App) => {
    components.forEach(component => app.component(component.name, component))
}

export {
    install,
    PrintTemplate
}