export default class ScaleOption {
    name: string;
    target!: HTMLElement;

    constructor() {
        // json 模板 options 对应键值 key
        this.name = 'scale';
    }

    // 涉及修改元素样式， 添加一个 css 方法
    // t: 元素对象， e 参数值
    css(target: HTMLElement, value: string | null): string | null {
        if (target) {
            if (value) {
                target.style.transform = 'scale(' + value + ')';
                return target.style.transform;
            }
        }
        return null;
    }

    // 创建 DOM
    createTarget(element: HTMLElement, options: any, printElementType: string): HTMLElement {
        // element: 元素对象，options: 元素 options, printElementType: 元素的打印类型
        this.target = document.createElement('div');
        this.target.classList.add('hiprint-option-item');
        this.target.innerHTML =
            '<div class="hiprint-option-item-label">\n        缩放\n        </div>\n        <div class="hiprint-option-item-field">\n        <input type="number" value="1" step="0.1" min="0.1" max="3" class="auto-submit"/>\n        </div>\n    </div>';
        return this.target;
    }

    // 获取值
    getValue(): number | undefined {
        const input = this.target.querySelector('input');
        if (input) {
            const value = input.getAttribute('value');
            if (value) {
                return parseFloat(value);
            }
        }
        return undefined;
    }

    // 设置值
    setValue(value: number | undefined): void {
        const input = this.target.querySelector('input');
        if (input) {
            input.setAttribute('value', value?.toString() || '');
        }
    }

    // 销毁 DOM
    destroy(): void {
        this.target.remove();
    }
}
