export default class FontSizeOption {
    name: string;

    constructor() {
        this.name = "fontSize";
    }

    // 涉及修改元素样式， 添加一个 css 方法
    css(target: HTMLSelectElement, size: string | null): string | null {
        if (target) {
            if (size) {
                target.style.fontSize = size + "pt";
                return "font-size:" + size + "pt";
            } else {
                target.style.fontSize = "";
            }
        }
        return null;
    }

    // 创建 DOM
    createTarget(): HTMLElement {
        const list = [8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72];
        let fontSizeList = '\n<option value="">默认</option>';
        list.forEach((e) => {
            fontSizeList += '\n<option value="' + e + '">' + e + 'pt</option>';
        });
        const target = document.createElement("div");
        target.classList.add("hiprint-option-item");
        target.innerHTML =
            '<div class="hiprint-option-item-label">\n字体大小\n</div>\n<div class="hiprint-option-item-field">\n<select class="auto-submit">\n' +
            fontSizeList +
            '\n</select>\n</div>\n';
        return target;
    }

    // 获取值
    getValue(target: HTMLElement): number | undefined {
        const select = target.querySelector("select");
        if (select) {
            const size = select.value;
            if (size) {
                return parseFloat(size);
            }
        }
        return undefined;
    }

    // 设置值
    setValue(target: HTMLElement, size: number | undefined): void {
        const select = target.querySelector("select");
        if (size && select) {
            const option = select.querySelector(`option[value="${size}"]`);
            if (!option) {
                select.insertAdjacentHTML("afterbegin", `<option value="${size}" >${size}</option>`);
            }
            select.value = size.toString();
        } else if (select) {
            select.value = "";
        }
    }

    // 销毁 DOM
    destroy(target: HTMLElement): void {
        target.remove();
    }
}
