import { defineConfig } from 'vite'
import { resolve } from 'path'
import vue from '@vitejs/plugin-vue' // 处理vue文件
import dts from 'vite-plugin-dts' //生成类库的声明文件.d.ts

const input = resolve('src') // 入口文件
const output = resolve('dist') // 输出文件

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    vue(),
    dts({
      include: ['src/**/*'],
      exclude: ['node_modules/**'],
    })
  ],
  resolve: {
    alias: [
      {
        find: '~',
        replacement: resolve('src'),
      },
    ],
  },
  server: {
    host: '0.0.0.0',
    port: 3008,
    strictPort: true, // 端口被占用直接退出
    https: false, // 默认用http方式
    open: true, // 在开发服务器启动时自动在浏览器中打开应用程序
    proxy: {
      '/lowcodeplatform-system': {
        target: 'http://192.168.1.41',
        // target: 'http://192.168.0.8:8089',
      }
    },
    hmr: {
      overlay: true, // 屏蔽服务器报错
    },
  },
  // 打包
  build: {
    // 打包输出目录
    outDir: output,
    minify: 'terser',
    terserOptions: {
      compress: {
        //生产环境时移除console
        drop_console: true,
        drop_debugger: true,
      },
    },
    lib: {
      entry: resolve(input, 'index.ts'),
      name: 'PrintVue',
      // 构建生成的文件名，与package.json中配置一致
      fileName: 'PrintVue',
    },
    rollupOptions: {
      output: {
        // 在 UMD 构建模式下为这些外部化的依赖提供一个全局变量
        globals: {
          vue: 'Vue',
          'element-plus': 'ElementPlus',
          axios: 'axios',
          vuex: 'vuex',
          'vue-router': 'vue-router',
          "jquery": 'jquery',
          'vue-plugin-hiprint': 'vue-plugin-hiprint'
        },
      },
      // 打包过滤掉第三方库
      external: [
        'vue',
        'element-plus',
        'axios',
        'vuex',
        'vue-router',
        'jquery',
        'vue-plugin-hiprint'
      ],
    },
  },
})
