import { request } from "../../config";

// 金蝶通用配置列表
export function getCommonConfig(
  pageNo?: number,
  pageSize?: number,
  name?: string
) {
  return request({
    url: "/api/kingdee/common/config/list",
    method: "get",
    params: { pageNo, pageSize, name },
  });
}

// 金蝶通用配置创建
export function addCommonConfig(data: any) {
  return request({
    url: "/api/kingdee/common/config/create",
    method: "post",
    data,
  });
}
// 金蝶通用配置更新
export function putCommonConfig(data: any) {
  return request({
    url: "/api/kingdee/common/config/update",
    method: "put",
    data,
  });
}
// 金蝶通用配置删除
export function deleteCommonConfig(id: number) {
  return request({
    url: "/api/kingdee/common/config/delete",
    method: "delete",
    params: { id },
  });
}
