import { TableConfigData } from "@/table/type";

const roleConfigData: TableConfigData = {
  title: '角色',
  tableTitle: [
    {
      label: '角色编码',
      prop: 'roleCode',
      type: 'input'
    },
    {
      label: '角色名称',
      prop: 'roleName',
      type: 'input'
    },
    {
      label: '角色描述',
      prop: 'roleDesc',
      type: 'input',
      inputType: 'textarea'
    },
    {
      label: '创建时间',
      prop: 'fdate',
      type: ''
    }
  ],
  drawerformData: {
    id: '',
    roleCode: '',
    roleName: '',
    roleDesc: ''
  },
  rules: {
    roleCode: [
      { required: true, message: '请输入角色编码', trigger: 'blur' }
    ],
    roleName: [
      { required: true, message: '请输入角色名称', trigger: 'blur' }
    ]
  },
  btnObj: {
    width: '200',
    isAdd: true,
    isDelete: true
  },
  apiKey: 'role',
  tableApi: '/list',
  dataKey: 'records'
}

export { roleConfigData }
