import { request } from "../../config";

// 查询表关系
export function getTableRelation(pageNo?: number, pageSize?: number) {
  return request({
    url: "/api/table/relation/list",
    method: "get",
    params: { pageNo, pageSize },
  });
}

// 表关系录入
export function addTableRelation(inVo: any) {
  return request({
    url: "/api/table/relation/create",
    method: "post",
    data: inVo,
  });
}

// 修改表关系
export function editTableRelation(inVo: any) {
  return request({
    url: "/api/table/relation/update",
    method: "put",
    data: inVo,
  });
}

// 删除表关系
export function deleteTableRelation(idList: any) {
  return request({
    url: "/api/table/relation/delete",
    method: "delete",
    params: { idList },
  });
}
