import { TableConfigData } from "@/table/type";

const bizunitData: TableConfigData = {
  title: '事业部',
  tableTitle: [
    {
      label: '事业部名称',
      prop: 'cname',
      type: 'input'
    },
    {
      label: '英文名称',
      prop: 'ename',
      type: 'input'
    },
    {
      label: '编号',
      prop: 'code',
      type: 'input'
    },
    {
      label: '对应部门',
      prop: 'depart',
      type: 'input'
    },
    {
      label: '关联产品线',
      prop: 'product',
      type: 'input'
    }
  ],
  drawerformData: {
    id: '',
    type: 0,
    cname: '',
    ename: '',
    code: '',
    product: ''
  },
  rules: {
    cname: [
      { required: true, message: '事业部名称', trigger: 'blur' }
    ]
  },
  btnObj: {
    width: '200',
    isAdd: true,
    isDelete: true
  },
  apiKey: 'department',
  tableApi: '/bizunit',
  dataKey: ''
}

export { bizunitData }
