import { TableConfigData } from "@/table/type";

const projectTypeData: TableConfigData = {
  title: '事业部',
  tableTitle: [
    {
      label: '项目类型',
      prop: 'cname',
      type: 'input'
    },
    {
      label: '英文名称',
      prop: 'ename',
      type: 'input'
    },
    {
      label: '编号',
      prop: 'code',
      type: 'input'
    },
    {
      label: '适用事业部',
      prop: 'bizunits',
      type: 'input'
    },
    {
      label: '生效时间',
      prop: 'effect_time',
      type: 'input'
    },
    {
      label: '失效日期',
      prop: 'lose_effect_time',
      type: 'input'
    },
    {
      label: '详细配置',
      prop: 'detail',
      type: 'input'
    }
  ],
  drawerformData: {
    id: '',
    cname: '',
    ename: '',
    code: '',
    bizunits: '',
    effect_time: '',
    lose_effect_time: '',
    detail: ''
  },
  rules: {
    cname: [
      { required: true, message: '项目类型名称', trigger: 'blur' }
    ]
  },
  btnObj: {
    width: '200',
    isAdd: true,
    isDelete: true
  },
  apiKey: 'project',
  tableApi: '/projectType',
  dataKey: ''
}

export { projectTypeData }
