import { createRouter, createWebHashHistory, RouteRecordRaw } from "vue-router";
import Layout from '@/layout/index.vue'
const routes: Array<RouteRecordRaw> = [
    {
        path: '/',
        component: Layout,
        redirect: '/menu',
    },
    {
        path: '/login',
        name: 'login',
        component: () => import("@/views/login/login.vue"),
    },
    {
        path: '/404',
        name: '404',
        component: () => import("@/views/exception/404.vue")
    },
    // {
    //     path: '/:catchAll(.*)',
    //     redirect: '/404'
    // }
]

export const asyncRoutes: Array<RouteRecordRaw> = []


const router = createRouter({
    history: createWebHashHistory(),
    // routes = routes:routes
    routes
})

export function addRoutes(routes:any){
    router.addRoute(routes)
}

export default router;
