import { request } from '../config'

export const getMapList = (kingdeeCommonConfigId?: number, pageNo?: number, pageSize?: number) => {
    return request({
        url: '/api/kingdee/field/mapping/list',
        method: 'get',
        params: { kingdeeCommonConfigId, pageNo, pageSize }
    })
}

export const createMap = (data: any) => {
    return request({
        url: '/api/kingdee/field/mapping/create',
        method: 'post',
        data
    })
}

export const updateMap = (data: any) => {
    return request({
        url: '/api/kingdee/field/mapping/update',
        method: 'put',
        data
    })
}

export const deleteMap = (data: any) => {
    return request({
        url: '/api/kingdee/field/mapping/delete',
        method: 'delete',
        data
    })
}