import { hLoading, sLoading, toast } from "./util";

export const baseUrl = "/K3Cloud";
// 部署到iis上用的
// export const baseUrl = "https://weixin3.lingqingkeji.com/k3cloud"
// export const baseUrl = "/XiBU"

// 封装公共申请办法
function request(
  url: string,
  method: "GET" | "POST" | "PUT" | "DELETE",
  data?: object | any,
  responseType?: string,
  isReject: boolean = false
) {
  return new Promise<any>(function (resolve, reject) {
    let header: any;
    sLoading();
    // header = { "Content-Type": "application/json" };
    header = {
      "Content-Type": "application/x-www-form-urlencoded",
    };
    url = baseUrl + url;
    uni.request({
      url,
      method,
      data,
      header,
      responseType,
      success(res: any) {
        hLoading();
        if (isReject) return resolve(res);
        if (
          res.data.code == 200 ||
          res.data.code == 400 ||
          res.data.code == 402
        ) {
          resolve(res);
        } else if (res.data.code == 500 || res.data.code == 401) {
          toast(res.data.msg);
          reject(res);
        } else {
          console.log(res.data.Result, "非200错误");
          if (!res.data.hasOwnProperty("code")) return resolve(res.data);
          //其余异样
          reject(res);
        }
      },
      fail(err: any) {
        hLoading();
        //申请失败
        uni.showToast({
          title: "连接服务器失败",
          icon: "none",
        });
        reject(err);
      },
    });
  });
}

export default request;
