import request from "@/utils/request";

/**
 * @brief 移交预约
 * @param  data
 * @return
 */
export const transferReservation = (data: any) => {
  return request(
    "/LQKJ.K3.FileSystem.WebApi.WebApiService.Add,LQKJ.K3.FileSystem.WebApi.common.kdsvc",
    "GET",
    data
  );
};

/**
 * @brief 发送验证码
 * @param Phone
 * @return
 */
export const verification = (Phone: any) =>
  request(
    "/LQKJ.K3.FileSystem.WebApi.WebApiService.Verification,LQKJ.K3.FileSystem.WebApi.common.kdsvc",
    "POST",
    { Phone }
  );

/**
 * @brief 查询日期时间
 * @param data
 * @return
 */
export const selectDateTime = (data: any) =>
  request(
    "/LQKJ.K3.FileSystem.WebApi.WebApiService.SelectDateTime,LQKJ.K3.FileSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

// 所在页面A：办事指南，B移交，C：查阅，D：存放
export const appointmentConfig = (FLOCATIONPAGECOM: any) =>
  request(
    "/LQKJ.K3.FileSystem.WebApi.WebApiService.AppointmentConfig,LQKJ.K3.FileSystem.WebApi.common.kdsvc",
    "POST",
    { FLOCATIONPAGECOM }
  );

// 查询预约
export const selectYuYue = (data: any) =>
  request(
    "/LQKJ.K3.FileSystem.WebApi.WebApiService.SelectYuYue,LQKJ.K3.FileSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

// 取消预约
export const cancelReservation = (data: any) =>
  request(
    "/LQKJ.K3.FileSystem.WebApi.WebApiService.CancelReservation,LQKJ.K3.FileSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

// 取消预约
export const attachmentDownLoad = (data: any) =>
  request(
    "/Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.AttachmentDownLoad.common.kdsvc",
    "POST",
    data
  );
