import { defineStore, createPinia } from "pinia";
import piniaPluginPersistedstate from "pinia-plugin-persistedstate";
import piniaPersistOption from "./config/piniaPersist";

export const useGlobalStore = defineStore({
  id: "globalStore",
  state() {
    return {
      transferData: null,
      referData: null,
      infoData: {} as any,
      phone: "",
      code: "",
    };
  },
  getters: {},
  actions: {
    setTransferData(transferData: any) {
      this.transferData = transferData;
    },
    setReferData(referData: any) {
      this.referData = referData;
    },
    setInfoData(infoData: string) {
      this.infoData = infoData;
    },
    setPhone(phone: string) {
      this.phone = phone;
    },
    setCode(code: string) {
      this.code = code;
    },
  },
  persist: piniaPersistOption("globalStore"),
});

const pinia = createPinia();
pinia.use(piniaPluginPersistedstate);

export default pinia;
