import { createRouter, createWebHashHistory, RouteRecordRaw } from "vue-router";
import Layout from "@/layout/index.vue";
const routes: Array<RouteRecordRaw> = [
  {
    path: "/",
    component: Layout,
    redirect: "/home",
    children: [
      {
        path: "/home",
        component: () => import("@/views/home/index.vue"),
        name: "home",
        meta: {
          title: "人才库基础设置",
          icon: "",
        },
      },
      {
        path: "/talentPool",
        component: () => import("@/views/talentPool/index.vue"),
        name: "talentPool",
        meta: {
          title: "人才库",
          icon: "",
        },
      },
    ],
  },
  {
    path: "/login",
    name: "login",
    component: () => import("@/views/login/login.vue"),
  },
  {
    path: "/bigData",
    component: () => import("@/views/bigData/index.vue"),
    name: "bigData",
    meta: {
      title: "人才大数据",
      icon: "",
    },
  },
  {
    path: "/404",
    name: "404",
    component: () => import("@/views/exception/404.vue"),
  },
  // {
  //     path: '/:catchAll(.*)',
  //     redirect: '/404'
  // }
];

export const asyncRoutes: Array<RouteRecordRaw> = [];

const router = createRouter({
  history: createWebHashHistory(),
  // routes = routes:routes
  routes,
});

export function addRoutes(routes: any) {
  router.addRoute(routes);
}

export default router;
