import { InjectionKey } from "vue"
import { useStore as baseUseStore, createStore, Store } from "vuex"
import tabs, { TabsState } from "@/store/modules/tabs"
import menu, { MenuState } from "@/store/modules/menu"
import { StarbosStore } from "./tools"

export type RootState = {
  tabs: TabsState
  menu: MenuState
}
//导入所有的模块
export const modules = {
  tabs: tabs,
  menu: menu,
}

export const key: InjectionKey<Store<RootState>> = Symbol()

export const store = createStore<RootState>({
  modules,
}) as StarbosStore

// 定义自己的 `useStore` 组合式函数
export function useStore() {
  return baseUseStore(key) as StarbosStore
}
