import { createRouter, createWebHashHistory } from 'vue-router'
import Layout from '@/Layout/index.vue'

const routes = [
  {
    path: '/',
    component: Layout,
    redirect: '/home',
    children: [
      {
        path: '/home',
        component: () => import('@/views/home/index.vue')
      },
      {
        path: '/policy',
        component: () => import('@/views/policy/index.vue')
      },
      {
        path: '/recruitmentManagement',
        component: () => import('@/views/recruitmentManagement/index.vue')
      },
      {
        path: '/recruitmentManagement/enterpriseRecruitment',
        component: () => import('@/views/recruitmentManagement/enterpriseRecruitment.vue')
      },
      {
        path: '/recruitmentManagement/personal',
        component: () => import('@/views/recruitmentManagement/personalRecruitment.vue')
      },
      {
        path: '/recruitmentManagement/enterprise',
        component: () => import('@/views/recruitmentManagement/enterpriseRecruitment.vue')
      },
      {
        path: '/recruitmentManagement/editCompany',
        component: () => import('@/views/recruitmentManagement/editCompany.vue')
      },
      {
        path: '/recruitmentManagement/addAdministrator',
        component: () => import('@/views/recruitmentManagement/addAdministrator.vue')
      },
      {
        path: '/recruitmentManagement/editPosition',
        component: () => import('@/views/recruitmentManagement/editPosition.vue')
      },
      {
        path: '/recruitmentManagement/editResume',
        component: () => import('@/views/recruitmentManagement/editResume.vue')
      },
      {
        path: '/recruitmentManagement/positionDetail',
        component: () => import('@/views/recruitmentManagement/positionDetail.vue')
      },
      {
        path: '/recruitmentManagement/companyDetail',
        component: () => import('@/views/recruitmentManagement/companyDetail.vue')
      },
      {
        path: '/recruitmentManagement/addAdmin',
        component: () => import('@/views/recruitmentManagement/addAdmin.vue')
      },
      {
        path: '/recruitmentManagement/seeMorePosition',
        component: () => import('@/views/recruitmentManagement/seeMorePosition.vue')
      },
      {
        path: '/recruitmentManagement/seeMoreCompany',
        component: () => import('@/views/recruitmentManagement/seeMoreCompany.vue')
      },
      {
        path: '/specialRecruitment',
        component: () => import('@/views/specialRecruitment/index.vue')
      },
      {
        path: '/streetOfficeSpecialTopic',
        component: () => import('@/views/streetOfficeSpecialTopic/index.vue')
      },
      {
        path: '/skillTraining',
        component: () => import('@/views/skillTraining/index.vue')
      },
      {
        path: '/flexibleEmploym',
        component: () => import('@/views/flexibleEmploym/index.vue')
      },
      {
        path: '/macaoYouthEmployment',
        component: () => import('@/views/macaoYouthEmployment/index.vue')
      },
      {
        path: '/employmentAssistance',
        component: () => import('@/views/employmentAssistance/index.vue')
      },
      {
        path: '/innovationEntrepreneurship',
        component: () => import('@/views/innovationEntrepreneurship/index.vue')
      },
      {
        path: '/collegeStudents',
        component: () => import('@/views/collegeStudents/index.vue')
      },
      {
        path: '/veterans',
        component: () => import('@/views/veterans/index.vue')
      },
      {
        path: '/housekeepingServices',
        component: () => import('@/views/housekeepingServices/index.vue')
      },
      {
        path: '/disabilitiesEmployment',
        component: () => import('../views/disabilitiesEmployment/index.vue')
      },
      {
        path: '/humanResourcesServices',
        component: () => import('@/views/humanResourcesServices/index.vue')
      },
      {
        path: '/trainingBase',
        component: () => import('@/views/trainingBase/index.vue')
      },
      {
        path: '/counterpartAssistance',
        component: () => import('@/views/counterpartAssistance/index.vue')
      },
      {
        path: '/commonDetail',
        component: () => import('@/components/commonDetail.vue')
      },
      {
        path: '/jobDetail',
        component: () => import('@/views/flexibleEmploym/details.vue')
      }
    ]
  },
  {
    path: '/RichTextEditor',
    component: () => import('@/views/editor/index.vue')
  }
  //{
  //配置404页面
  //path: '/:catchAll(.*)',
  //name: '404',
  //component: () => import(''),
  //}
]

// 路由
const router = createRouter({
  history: createWebHashHistory(),
  routes,
  scrollBehavior(to, from, savedPosition) {
    // 滚动到顶部
    return { top: 0 }
  }
})
// 导出
export default router
