import request from '@/services'

// 获取职位类型
export const getPosition = () => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SePositionInfo,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc'
  )
}

// 发布、修改职位
export const postPosition = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.PostJobs,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 更新职位开发状态
export const updatePositionStatus = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.UpPositionStatus,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 企业查询企业信息
export const getCompanyInfo = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeEnterpriseInfo,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 企业查询企业信息
export const getAdminCompanyInfo = () => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeEnterpriseInfoQY,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc'
  )
}

// 企业修改企业信息
export const editCompanyInfo = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.UpdateEnterprise,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 企业端岗位管理列表
export const getCompanyPositionList = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeJobListQY,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 预览企业端岗位管理内容
export const getCompanyPositionDetail = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeJobContent,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}
// 查询企业端岗位管理内容
export const getEditPositionDetail = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeJobContentUp,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}
// 删除企业端岗位
export const deleteCompanyPosition = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.DelteJobs,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 个人用户查询详细岗位列表
export const getUserPostionList = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeUserJobsList,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 个人用户查询详细岗位
export const getUserPostionDetail = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeJobDetails,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}
// 企业添加管理员
export const addAdmin = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.AddAdmin,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}
// 个人用户查看简历信息
export const getResume = () => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeResumeInfoGR,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc'
  )
}
// 个人用户修改简历信息
export const updateResume = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.UpdateResumeInfo,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}
// 个人用户删除简历信息
export const deleteResume = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.DeleteResumeInfo,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

export const getHotPosition = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeHotJobPage,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

export const getHotCompany = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeFirmPage,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 投递简历
export const sendResume = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.SendResume,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 人才管理
// 企业更改简历状态
export const updateTalentResume = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiEditService.ChangeState,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 企业人才管理简历查询
export const getTalentResume = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.SeTalentManagement,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}

// 企业人才管理简历查询
export const getResumeSearch = (data: any) => {
  return request.post(
    '/LQKJ.K3.NSJYBSystem.WebApi.WebApiService.ResumeSearch,LQKJ.K3.NSJYBSystem.WebApi.common.kdsvc',
    data
  )
}
