import { useUserInfoStore } from '@/stores/modules/userInfo'

const userInfoStore = useUserInfoStore()
const companyInfo = computed(() => userInfoStore.getCompanyInfo)

export const filterList = ref([
  {
    name: '工作经验',
    prop: 'FEXPERIENCE',
    list: []
  },
  {
    name: '薪资待遇',
    list: [],
    prop: 'SalaryRange'
  },
  {
    name: '学历要求',
    list: [],
    prop: 'FEDUCATIONALBACKGROUND'
  },
  {
    name: '公司规模',
    list: [],
    prop: 'FSCALES'
  },
  {
    name: '融资情况',
    list: [],
    prop: 'FFINANCINGS'
  }
])

export const recruitStatus = [
  { status: '简历未查看', value: companyInfo.value?.NotViewed + '份' },
  { status: '简历待定', value: companyInfo.value?.Pending + '份' },
  { status: '安排面试', value: companyInfo.value?.Arrange + '份' },
  { status: '已面试', value: companyInfo.value?.HaveInterview + '份' },
  { status: '已录用', value: companyInfo.value?.HaveHired + '份' },
  { status: '已入职', value: companyInfo.value?.AlreadyBoard + '份' },
  { status: '人才库', value: companyInfo.value?.TalentPool + '份' },
  { status: '黑名单', value: companyInfo.value?.Blacklist + '份' }
]

export const positionList = [
  { name: '全部职位', type: '' },
  { name: '开放中', type: 'A' },
  { name: '已关闭', type: 'B' }
]

export const resumeList = [
  { name: '个人信息' },
  { name: '个人优势' },
  { name: '期望职位' },
  { name: '工作经历' },
  { name: '项目经历' },
  { name: '教育经历' },
  { name: '自定义添加' },
  { name: '上传简历' },
  { name: '上传附件' }
]
