export function throttle(fn: () => void, time = 2000) {
  let canRun: boolean = true
  return function () {
    if (!canRun) return
    canRun = false
    setTimeout(() => {
      fn()
      canRun = true
    }, time)
  }
}

export const debounce = (func: Function, wait: number) => {
  let timeout: ReturnType<typeof setTimeout> | null
  return function (this: any, ...args: any[]) {
    const context = this
    if (timeout) clearTimeout(timeout)
    timeout = setTimeout(() => {
      func.apply(context, args)
    }, wait)
  }
}
