import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
// 自动导入icon图标
import Icons from 'unplugin-icons/vite'
import IconsResolver from 'unplugin-icons/resolver'
// 导入自动装配插件
import AutoImport from 'unplugin-auto-import/vite'
//自动导入ui-组件
import Components from 'unplugin-vue-components/vite'
// 配置@别名
import { resolve } from 'path'
// 按需引入element-plus
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers'
// Vue3 setup 语法糖下定义组件名称 <script lang="ts" setup name="home">
import VueSetupExtend from 'vite-plugin-vue-setup-extend'
// 引入viteMockServe 配置mock
import { viteMockServe } from 'vite-plugin-mock'
import eslintPlugin from 'vite-plugin-eslint'

export default defineConfig({
  plugins: [
    vue(),
    VueSetupExtend(),
    eslintPlugin({
      include: ['src/**/*.ts', 'src/**/*.vue', 'src/*.ts', 'src/*.vue']
    }),
    viteMockServe({
      mockPath: 'src/mock/'
    }),
    // 配置自动装载配置
    AutoImport({
      // 生成配置文件，如果是ts项目，通常我们会把声明文件放在根目录/types中，注意，这个文件夹需要先建好，否则可能导致等下无法往里生成auto-imports.d.ts文件
      dts: 'types/auto-imports.d.ts',
      imports: ['vue', 'vue-router', 'pinia'],
      resolvers: [
        ElementPlusResolver(),
        IconsResolver({
          prefix: 'Icon'
        })
      ],
      eslintrc: {
        // 默认false, true启用。生成一次就可以，
        // 避免每次工程启动都生成，
        // 一旦生成配置文件之后，最好把enable关掉，即改成false。
        // 否则这个文件每次会在重新加载的时候重新生成，这会导致eslint有时会找不到这个文件。当需要更新配置文件的时候，再重新打开
        enabled: false,
        // 生成json文件,可以不配置该项，默认就是将生成在根目录
        filepath: './.eslintrc-auto-import.json',
        globalsPropValue: true
      }
    }),
    Components({
      // 引入组件的,包括自定义组件
      // 存放的位置
      dts: 'types/components.d.ts',
      resolvers: [
        ElementPlusResolver(),
        IconsResolver({
          enabledCollections: ['ep']
        })
      ]
    }),
    Icons({
      autoInstall: true
    })
  ],
  // ↓解析配置
  resolve: {
    // ↓路径别名
    alias: {
      '@': resolve(__dirname, './src')
    }
  },
  server: {
    port: 4000, //设置服务启动端口号，是一个可选项，不要设置为本机的端口号，可能会发生冲突
    open: true, //是否自动打开浏览器，可选项
    cors: true, //允许跨域。
    host: '0.0.0.0',
    // 设置代理
    proxy: {
      '/api2': {
        target: 'http://127.0.0.1:5173/',
        changeOrigin: true,
        rewrite: path => path.replace(/^\/api2/, '')
      },
      '/api': {
        target: 'https://rms.junrunrenli.com',
        changeOrigin: true
      },
      '/K3Cloud': {
        target: 'http://192.168.1.168',
        changeOrigin: true
      }
    }
  },
  build: {
    minify: 'terser',
    terserOptions: {
      compress: {
        //生产环境时移除console.log()
        drop_console: true,
        drop_debugger: true
      }
    }
  }
})
