import { defineStore } from 'pinia'
import { GlobalState } from '../interface'
import piniaPersistConfig from '../helper/piniaPersist'

export const useGlobalStore = defineStore('globalStore', {
  // 相当于data
  state: (): GlobalState => {
    return {
      token: ''
    }
  },
  // 相当于计算属性
  getters: {
    getToken: state => state.token
  },
  actions: {
    setToken(token: string) {
      this.token = token
    }
  },
  persist: piniaPersistConfig('globalStore')
})
