import { defineStore, createPinia } from 'pinia'
import piniaPersistConfig from '../utils/piniaPersist'
import piniaPersist from 'pinia-plugin-persist'

export const useGlobalStore = defineStore('globalStore', {
  // 相当于data
  state: () => {
    return {
      token: '',
      jobDetail: null as any
    }
  },
  // 相当于计算属性
  getters: {
    getJobDtail: state => state.jobDetail
  },
  actions: {
    setToken(token: string) {
      this.token = token
    },
    setJobDetail(jobDetail: any) {
      this.jobDetail = jobDetail
    }
  },
  persist: {
    enabled: true,
    strategies: [{ storage: localStorage, paths: ['jobDetail'] }]
  }
})

const pinia = createPinia()

pinia.use(piniaPersist)

export default pinia
