import { defineStore } from 'pinia'
import piniaPersistConfig from '../helper/piniaPersist'

export const useUserInfoStore = defineStore('userInfoStore', {
  // 相当于data
  state: () => {
    return {
      personalInfo: {} as any,
      companyInfo: {} as any
    }
  },
  // 相当于计算属性
  getters: {
    getPersonalInfo: state => state.personalInfo,
    getCompanyInfo: state => state.companyInfo,
    isPersonalOrCompany: state => {
      if (JSON.stringify(state.personalInfo) !== '{}') return 0
      if (JSON.stringify(state.companyInfo) !== '{}') return 1
    }
  },
  actions: {
    setPersonalInfo(personalInfo: any) {
      this.personalInfo = personalInfo
    },
    setCompanyInfo(companyInfo: any) {
      this.companyInfo = companyInfo
    }
  },
  persist: piniaPersistConfig('userInfoStore')
})
