export const LOGIN_URL = 'login'

export const locationIcon =
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAACXBIWXMAABYlAAAWJQFJUiTwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAKXSURBVHgB5VddbtNAEP52bZ6xT0A4QdMTkN4AK0VCYKntCVJOkOQEDScgSElViZaEEzQ9QcwJMCdIoOIJe5dZN0Kt7f1xmrd+kiVrZ3bmW+/8GXjqYE2UV7O3LR/+kRToSLAWIFsb0ZoMJZJjLuB/C6Nx6mjSjcBqdtzyRPZJAh0XfQY5zvmzoQsRblO4ncU9LrKlq3MF+jrHtOfH6ur9qU3XSOD2Ku4LgRG9BtgCHOyMDtA36TCjc2CAHUBAfgi70xFcCag7V58Qu8NacH+/LiZqr4AC7gy7RaCCuE5QIaBOTwH3GgZIiQXFxoHg2cvikYhoNTXuoSBefYk75XW/oplnp6bkpLgYhoeTQWk5pWe+uoxHnKGn3cyLTFo8XCrBA/Z0++nkSditOP8PIqbIJzo52X6FCqeyE4a2Zj84lyNYIKT8rJPRNbStBGDI+TyT32FlwBKDNHAhoIXn+y+sSqxZ0aohwFKdci7FPqwGpT6DZDU+KgSokSR64+ipNNXJCxljRzo5VcSfNTYfIoe8gR4BF3+v60ioHFcyw154HLPyWiXjyXiwKcPGu6SNi1zghjMRMMb37N1SpoLnB2F0kZbsVEGnGXCOPnaIooDV1JD6LPD9ka20NoNMdQWslgB1rbX6XPS6xg6cb2zBmcAdiYuUGk6ER0IIdlK+dycCBYk3k4UaJrCtc3XvZMOk4zaU2rpcnXOJj0VzssB5LP/1NV5SJWs7KUuZPD+cWqumgnMvECyL3DKDgs7LnWOn4Y/JuzYXXFU7bZFSE5Ip6Mpo1A3D6DwRENqgFIKm3wbOGxMoSHTPx5Sew/L6XcRPrQNLGY2u4D5+X8bXND111Dv1gXnQnWxVM3xsidzzI+p+y4IA/3OCLfEPs98Ki5hkgnEAAAAASUVORK5CYII='

export const companyIcon =
  'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAYAAABw4pVUAAAACXBIWXMAABYlAAAWJQFJUiTwAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAANZSURBVHgB7dxNTxNBHMfx/8zslioUsAjREIEYfCJcjLeacDJGX4dnook3T/XiTYjh7BuAF2CiHoiJ3ownjTHEYAxqohS0Bfu0HTvVRsBG0lh2f2t/nwNpKaEN38xMZ9JFyR42K4lcejKZKOWT2ksaoY4LgnIlKPRUB1+u5tWSBDsfU80b1orKLaRTySDVKxSaovG30rMreaXEuvuNIC5G/u7pIWNKvlDo3IhJ3fy47qJo9w03MhgjOsYk/NzCZMrdVnZRzPba+IhQ5A5/7V3Xm2sTKSEIufSnpC5ue5yqQCRKR5K6/3DFE4KgvarRQlAYBAyDgGEQMAwChkHAMAgYBgHDIGAYBAyDgGEQMAwChkHAMAgYBgHDIGAYBAyDgGEQMBAfcFCjl054w1PzVulpUapf/lWt8iD4/Dpr1x6/l5iJPIiLYUamH9lOhGjS/tX678wEIpfjFiXyKUsPn70tnYzRpNRAfdTNScxEHkRp/4ockMYUGDP/96J+ECPvgPFdFhgGAcMgYGA/aJ2Yub7rfvnJvbYejyuOEDAMAoZBwMCuIfutCe2vGUrURGbMP3pmTrSpbxhb7FHqZ2D2y5tsZfVpZMctXXL1lItxccwfOfewZYim+hmYGpnK+PUzsKiidMeUpbTyh05l/xrj9w8PKDeKItIVQaz79wimjTOzxpQWDe5DWoruDIzvssB07SXRXubWrvvVZ3cEAUcImC7ah8QDRwiYrl1DUNaMvThCwHAfAoYjBAz3Ib9wH0ItcR8ChiOkwQoK7kPAcISAYRAwDAKGQcAwCBgGAcMgYBgETOgbQ6uNkhA1nk97bT9n83WqWhDqNl5tzY8flxCp89c+SHxY++L+qISIUxYYBgETxeEiztHq/kJ/reEv6iHPyXHDKQsMg4BhEDAMAoZBwDAIGAYBwyBgGAQMg4BhEDAMAoZBwDAIGAYBwyBgGAQMg4BhEDAMAkbXql4gBCEIyhVd7tkoCkFIVQ9VdDp3jEFQPH9b0Cr7qlw0/pZQpFwDtSRBY1FfyK0Uvm2XqkKRCGqVSnp2Je9uG/dleVlsaqZQvNA7rDxbSwiFxo2MwRvvNpX6+bHVP66bsIv1SBsn+/L5774xCV+oo9wfvMeUqpvSV0rnEkW3ZOx8/AeuseK4CcGZoQAAAABJRU5ErkJggg=='

//  深拷贝
export const deepCopy = (obj: any) => {
  // 检查是否为可复制的对象（数组或对象）
  if (typeof obj !== 'object' || obj === null) {
    return obj
  }

  // 创建新的对象或数组
  const copy: any = Array.isArray(obj) ? [] : {}

  // 遍历原始对象或数组，递归地进行深拷贝
  for (let key in obj) {
    if (Object.prototype.hasOwnProperty.call(obj, key)) {
      copy[key] = deepCopy(obj[key])
    }
  }

  // 返回新的对象或数组
  return copy
}

export const jsonp = function (url: any, data: any) {
  return new Promise((resolve, reject) => {
    // 1.初始化url
    const windows: any = window
    let dataString = url.indexOf('?') === -1 ? '?' : '&'
    let callbackName = `jsonpCB_${Date.now()}`
    url += `${dataString}callback=${callbackName}`
    if (data) {
      // 2.有请求参数，依次添加到url
      for (let k in data) {
        url += `&${k}=${data[k]}`
      }
    }

    let scriptNode = document.createElement('script')
    scriptNode.src = url

    // 3. callback
    windows[callbackName] = (result: any) => {
      result ? resolve(result) : reject('没有返回数据')
      delete windows[callbackName]
      document.body.removeChild(scriptNode)
    }

    // 4. 异常情况
    scriptNode.addEventListener(
      'error',
      () => {
        reject('接口返回数据失败')
        delete windows[callbackName]
        document.body.removeChild(scriptNode)
      },
      false
    )

    // 5. 开始请求
    document.body.appendChild(scriptNode)
  })
}
