import request from "@/utils/request";

/**
 * @brief 静默登录
 * @param  code 微信授权code
 * @param  type 0 老师 1 学生
 */
export const login = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.User,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data,
    undefined,
    true
  );

/**
 * @brief 学员注册
 * @param data
 * @return
 */
export const register = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.Login,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 发送验证码
 * @param Phone
 * @return
 */
export const verification = (Phone: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.Verification,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    { Phone }
  );

/**
 * @brief 手机验证码登录
 * @param Phone
 * @return
 */
export const loginCode = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.LoginCode,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 手机密码登录
 * @param data
 * @return
 */
export const teachLogin = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.TeachLogin,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );
/**
 * @brief 获取openId
 * @param data
 * @return
 */
export const getOpenId = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.GetOpenID,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );
