import request from "@/utils/request"

// 查询所有报名的课程信息
export const getTrainAll = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.CourseSelect,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 查询已报名
 * @param FMOBILE 手机号
 * @return
 */
export const getTrainList = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.CourseIn,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 查询已报名
 * @param TypeId //1:所属党委,0:所属街道
 * @return
 */
export const getInFormAtion = () =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.InFormAtion,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST"
  )

/**
 * @brief 报名
 * @param TypeId //1:所属党委,0:所属街道
 * @return
 */
export const signUp = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.SignUp,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 退出报名
 * @param classId
 * @param Phone
 * @return
 */
export const quit = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.Quit,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )
