import request from "@/utils/request";

/**
 * @brief 查询每个班级通讯录信息
 * @param  CLASSID // 班级内码
 * @return
 */
export const getClassBook = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.ClassBook,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 查询我的班级
 * @param  FMOBILE // 手机号
 * @return
 */
export const getClassDetail = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.ClassMessage,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 评价
 * @param  data
 * @return
 */
export const remarkOn = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.RemarkOn,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 查看评价
 * @param  data
 * @return
 */
export const remarkDetail = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.RemarkDetail,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

// 查询班级
export const getClassList = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.TeachMgt,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );
