import request from "@/utils/request"

/**
 * @brief 查询我的课程
 * @param  FMOBILE //手机号码
 * @param  type //0：上课中,1：已结束,2：未开始
 * @return
 */
export const getTeachCourse = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.TeachCoursDetail,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 查询我的课程
 * @param  FMOBILE //手机号码
 * @param  type //0：上课中,1：已结束,2：未开始
 * @return
 */
export const getCourseList = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.TeachAndCourse,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 查询讲师介绍和课程介绍
 * @param  TeachName // 班级名称
 * @param  CouseId // 课程内码
 * @return
 */
export const getTeachDetail = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.TeachDetail,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 签到签退
 * @param  data
 * @return
 */
export const signInAndOut = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.ClockId,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )

/**
 * @brief 查看附件
 * @param  data
 * @return
 */
export const getFileList = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.FilePDF,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )
/**
 * @brief 查看附件
 * @param  data
 * @return
 */
export const getStateList = (data?: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiService.StateList,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  )
