import { defineConfig } from 'vite';
// import pxtovw from 'postcss-px-to-viewport'
import { resolve } from 'path';
import { createSvgIconsPlugin } from 'vite-plugin-svg-icons';
import uni from '@dcloudio/vite-plugin-uni';
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import mkcert from "vite-plugin-mkcert";

export default defineConfig({
    plugins: [
        uni(),
        mkcert(),
        createSvgIconsPlugin({
            iconDirs: [resolve(process.cwd(), 'src/static/svg')],
            symbolId: 'icon-[dir]-[name]',
        }),
        AutoImport({
            include: [
                /\.[tj]sx?$/, // .ts, .tsx, .js, .jsx
                /\.vue$/,
                /\.vue\?vue/, // .vue
            ],
            imports: [
                'vue',
                'uni-app',
                'pinia',
            ],
            dts: 'src/auto-imports.d.ts',
        }),
        Components({
            dirs: ['src/components'],
            dts: 'src/components.d.ts',
        })

    ],
    resolve: {
        alias: {
            '@': resolve(__dirname, './src'),
        },
    },
    css: {
        preprocessorOptions: {
            scss: {
                additionalData: `@import "@/uni.scss";`,
            },
        },
        postcss: {
            // plugins: [loder_pxtovw]
        },
    },
    assetsInclude: '@dcloudio/uni-ui',
    build: {
        minify: 'terser',
        terserOptions: {
            compress: {
                drop_console: true, // 生产环境移除console
                drop_debugger: true, // 生产环境移除debugger
            },
        },
    },
    server: {
        host: '0.0.0.0',
        port: 7897,
        open: true,
        strictPort: false, // 端口被占用直接退出
        https: true, // 默认用http方式
        proxy: {
            '/XiBU': {
                target: 'http://192.168.1.12',
            }
        },
    },
});
