import { defineStore, createPinia } from "pinia"
import piniaPluginPersistedstate from "pinia-plugin-persistedstate"
import piniaPersistOption from "./config/piniaPersist"

export const useGlobalStore = defineStore({
  id: "globalStore",
  state() {
    return {
      Phone: "",
      infoData: {} as any,
    }
  },
  getters: {},
  actions: {
    setPhone(Phone: string) {
      this.Phone = Phone
    },
    setInfoData(infoData: string) {
      this.infoData = infoData
    },
  },
  persist: piniaPersistOption("globalStore"),
})

const pinia = createPinia()
pinia.use(piniaPluginPersistedstate)

export default pinia
