import AMapLoader from "@amap/amap-jsapi-loader";

const Map = reactive({
    myMap: {} as any, //把AMap中的方法保存在浏览器
    lng: "",
    lat: ""
});

export const useAMap = () => {
    const initMap = () => {
        AMapLoader.load({
            key: "e2f3c4f1d287a2bf00de849aaf71d8d4", // 申请Web端开发者Key
            version: "2.0", // 指定要加载的 JSAPI 的版本
            plugins: [
                "AMap.Geolocation",
            ], // 需要使用的的插件列表,此处以定位为例
        }).then((AMap) => {
            Map.myMap = AMap;//保存获取到的方法
            //调用获取定位方法
            getGeolocation();
        });
    };

    //地图定位
    function getGeolocation() {
        var Geolocation = new Map.myMap.Geolocation({
            enableHighAccuracy: true, //是否使用高精度定位，默认:true
            timeout: 10000, //超过10秒后停止定位，默认：5s
        });
        Geolocation.getCurrentPosition(function (status: any, result: any) {
            if (status == "complete") {
                onComplete(result);
            } else {
                onError(result);
            }
        });
    }
    //解析定位结果
    function onComplete(data: any) {
        console.log(data);
        Map.lat = data.position.lat;
        Map.lng = data.position.lng;
    }
    //解析定位错误信息
    function onError(data: any) {
        console.log(data);
    }

    function getLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition);
        } else {
            alert("您的浏览器不支持获取地理位置信息。");
        }
    }

    function showPosition(position: any) {
        console.log(position);
        var latitude = position.coords.latitude;
        var longitude = position.coords.longitude;
        uni.request({
            url: 'https://restapi.amap.com/v3/geocode/regeo', //逆地理编码接口地址。
            data: {
                key: 'e2f3c4f1d287a2bf00de849aaf71d8d4',
                //location：经纬度  lng ：经度  lat：纬度
                location: longitude + ',' + latitude,
                radius: 1000,
                extensions: 'all',
                batch: false,
                roadlevel: 0
            },
            header: {
                //自定义请求头信息
            },
            success: (res: any) => {
                //详细地址信息
                console.log(res.data.regeocode);
            }
        })

        // alert("您当前的位置经纬度为：\n纬度：" + latitude + "\n经度：" + longitude);
    }

    return { initMap, Map }
}
