import { defineStore, createPinia } from "pinia"
import piniaPluginPersistedstate from "pinia-plugin-persistedstate"
import piniaPersistOption from "./config/piniaPersist"

export const useGlobalStore = defineStore({
  id: "globalStore",
  state() {
    return {
      Phone: "",
      studentNumber: "",
      studentId: "",
    }
  },
  getters: {},
  actions: {
    setPhone(Phone: string) {
      console.log(Phone, "Phone")
      this.Phone = Phone
    },
    setStudentNumber(studentNumber: string) {
      this.studentNumber = studentNumber
    },
    setStudentId(studentId: string) {
      this.studentId = studentId
    },
  },
  persist: piniaPersistOption("globalStore"),
})

const pinia = createPinia()
pinia.use(piniaPluginPersistedstate)

export default pinia
