import { jsonp } from "./util";

const mapsInfo = reactive({
    lat: '', // 纬度
    lng: '', // 经度
    addr: '' // 地址
})

const windows: any = window

const useQqMaps = () => {
    const geolocation = new windows.qq.maps.Geolocation(
        "3M5BZ-SFCRJ-AHSF7-XRA5Q-Y6NIJ-DXBH4",
        "XBRLPX"
    )

    const initQqMaps = () => {
        // 获取当前所在地理位置
        geolocation.getLocation(showPosition, showErr)
    }

    // 监听位置信息的改变
    const watchPosition = () => {
        geolocation.watchPosition(updatePosition)
    }

    // 清除监听
    const clearWatch = () => {
        geolocation.clearWatch()
    }

    const showPosition = (position: any) => {
        let url = 'https://apis.map.qq.com/ws/geocoder/v1/'
        jsonp(url, {
            key: '3M5BZ-SFCRJ-AHSF7-XRA5Q-Y6NIJ-DXBH4',
            output: 'jsonp',
            // 需要传入的参数
            location: position.lat + ',' + position.lng,
            get_poi: 1
        }).then((res: any) => {
            // console.log(res.result, 'res.result');
            mapsInfo.addr = res.result.address
        })
    }

    const updatePosition = (data: any) => {
        console.log(data);

    }
    const showErr = () => { }

    // 计算距离
    const calculateDistance = (lat1: Number, lon1: Number, lat2: Number, lon2: Number) => {
        const point1 = new windows.qq.maps.LatLng(lat1, lon1);
        const point2 = new windows.qq.maps.LatLng(lat2, lon2);
        // 使用 computeDistanceBetween 方法计算距离
        var distance = windows.qq.maps.geometry.spherical.computeDistanceBetween(point1, point2);

        return distance; // 返回距离，单位为米
    }
    return {
        initQqMaps,
        watchPosition,
        clearWatch,
        calculateDistance,
        mapsInfo
    }
}

export default useQqMaps