import config from "./config"

export const baseUrl = "/k3cloud"
// 部署到iis上用的
// const baseUrl = "https://weixin.lingqingkeji.com:86/k3cloud"
// const baseUrl = "/XiBU"

// 封装公共申请办法
function request(
  url: string,
  method: "GET" | "POST" | "PUT" | "DELETE",
  data?: object | any,
  responseType?: string
) {
  return new Promise<any>(function (resolve, reject) {
    let header: any
    uni.showLoading({
      title: "加载中...",
    })
    header = { "Content-Type": "application/json" }
    url = baseUrl + url

    uni.request({
      url,
      method,
      data,
      header,
      responseType,
      success(res: any) {
        uni.hideLoading()
        if (res.data.code == 200) {
          resolve(res)
        } else if (res.data.code == 500 || res.data.code === 401) {
          uni.showToast({
            title: res.data.msg,
            icon: "none",
          })
          reject(res)
        } else if (res.data.code == 501 || res.data.code == 911) {
          uni.reLaunch({
            url: "/pages/login/index",
            success() {
              uni.showToast({
                title: "请登录",
                icon: "none",
              })
            },
          })
        } else {
          console.log(res, "非200错误")
          //其余异样
          reject(res)
        }
      },
      fail(err: any) {
        uni.hideLoading()
        //申请失败
        uni.showToast({
          title: "连接服务器失败",
          icon: "none",
        })
        reject(err)
      },
    })
  })
}

export default request
