import request from "@/utils/request";

/**
 * @brief 静默登录
 * @param  code 微信授权code
 * @param  type 0 老师 1 学生
 */
export const login = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.User,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 学员注册
 * @param data
 * @return
 */
export const register = (data: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.Login,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    data
  );

/**
 * @brief 发送验证码
 * @param Phone
 * @return
 */
export const verification = (Phone: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.Verification,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    { Phone }
  );

/**
 * @brief 手机验证码登录
 * @param Phone
 * @return
 */
export const loginCode = (Phone: any) =>
  request(
    "/LQKJ.K3.PeiXunSystem.WebApi.WebApiEditService.LoginCode,LQKJ.K3.PeiXunSystem.WebApi.common.kdsvc",
    "POST",
    { Phone }
  );
