import { defineStore, createPinia } from "pinia"
import piniaPluginPersistedstate from "pinia-plugin-persistedstate"
import piniaPersistOption from "./config/piniaPersist"

export const useGlobalStore = defineStore({
  id: "globalStore",
  state() {
    return {
      infoData: {} as any,
      openId: "",
    }
  },
  getters: {},
  actions: {
    setInfoData(infoData: any) {
      this.infoData = infoData
    },
    setOpenId(openId: string) {
      this.openId = openId
    },
  },
  persist: piniaPersistOption("globalStore"),
})

const pinia = createPinia()
pinia.use(piniaPluginPersistedstate)

export default pinia
