import request from './config'

export const getTenantList = () => {
  return request.get('/admin/docker/listTenant')
}

export const getListAll = (tenantId: any) => {
  return request.get('/admin/docker/listAll', tenantId)
}

export const getLogs = (data: any) => {
  return request.post('/admin/docker/logs', data)
}

export const getMessage = (tenantId: any) => {
  return request.get('/admin/docker/message', { tenantId })
}

export const getMessageList = (data: any) => {
  return request.get('/admin/docker/message/list', data)
}

export const startAll = (tenantId?: any) => {
  return request.post('/admin/docker/startAll', { tenantId })
}

export const updateAll = (tenantId?: any) => {
  return request.post('/admin/docker/updateAll', { tenantId })
}

export const cleanAll = (tenantId?: any) => {
  return request.post('/admin/docker/clean', { tenantId })
}

export const getMac = () => {
  return request.post('/admin/api/lic/info/mac')
}

export const startOne = (data: any) => {
  return request.post('/admin/docker/startOne', data)
}

export const updateOne = (data: any) => {
  return request.post('/admin/docker/updateOne', data)
}

export const restartOne = (data: any) => {
  return request.post('/admin/docker/restart', data)
}

export const cleanOne = (data: any) => {
  return request.post('/admin/docker/cleanOne', data)
}

export const startBatch = (data: any) => {
  return request.post('/admin/docker/start', data)
}

export const updateBatch = (data: any) => {
  return request.post('/admin/docker/update', data)
}

export const cleanBatch = (data: any) => {
  return request.post('/admin/docker/clean', data)
}

export const getJarList = () => {
  return request.get('/admin/docker/jar/list')
}

export const jarRestart = (data: any) => {
  return request.get('/admin/docker/jar/restart', data)
}

export const headSystem = (data: any) => {
  return request.head('/admin/api/docker/backDownload', data)
}

export const systemSegmentationDownload = (data: any, object?: any) => {
  return request.segmentationDownload('/admin/api/docker/backDownload', data, object)
}

export const backupSystem = (data: any) => {
  return request.get('/admin/api/docker/backSystem', data)
}

export const downloadProgress = (data: any) => {
  return request.get('/admin/api/docker/backSystemProgress', data)
}

export const reductionProgress = (data: any) => {
  return request.get('/admin/api/docker/revertSystemProgress', data)
}

export const reductionCheck = (data: any) => {
  return request.get('/admin/api/docker/revertSystemCheck', data)
}
